/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate.products;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetMonteCarloSimulation;
import net.finmath.montecarlo.hybridassetinterestrate.RiskFactorFX;
import net.finmath.montecarlo.hybridassetinterestrate.RiskFactorForwardRate;
import net.finmath.montecarlo.hybridassetinterestrate.products.HybridAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class ForwardRateAgreementGeneralized
extends HybridAssetMonteCarloProduct {
    private final LocalDateTime referenceDate;
    private final String currency;
    private final double fixing;
    private final double periodStart;
    private final double periodEnd;
    private final RandomVariable spread;
    private final RandomVariable cap;
    private final RandomVariable floor;

    public ForwardRateAgreementGeneralized(LocalDateTime referenceDate, String currency, double fixing, double periodStart, double periodEnd, RandomVariable spread, RandomVariable cap, RandomVariable floor) {
        this.referenceDate = referenceDate;
        this.currency = currency;
        this.fixing = fixing;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.spread = spread;
        this.cap = cap;
        this.floor = floor;
    }

    public ForwardRateAgreementGeneralized(LocalDateTime referenceDate, String curve, double fixing, double periodStart, double periodEnd) {
        this(referenceDate, curve, fixing, periodStart, periodEnd, null, null, null);
    }

    public ForwardRateAgreementGeneralized(String currency, double fixing, double periodStart, double periodEnd) {
        this(null, currency, fixing, periodStart, periodEnd);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, HybridAssetMonteCarloSimulation model) throws CalculationException {
        double productToModelTimeOffset = 0.0;
        try {
            if (this.referenceDate != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), this.referenceDate);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable numeraire = model.getNumeraire(productToModelTimeOffset + this.periodEnd);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(productToModelTimeOffset + this.periodEnd);
        RandomVariable values = model.getValue(new RiskFactorForwardRate(this.currency, productToModelTimeOffset + this.periodStart, productToModelTimeOffset + this.periodEnd), productToModelTimeOffset + this.fixing);
        if (this.spread != null) {
            values = values.add(this.spread);
        }
        if (this.cap != null) {
            values = values.cap(this.cap);
        }
        if (this.floor != null) {
            values = values.floor(this.floor);
        }
        values = values.mult(model.getValue(new RiskFactorFX(this.currency), this.periodEnd));
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }
}

