/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public interface TermStructureMonteCarloSimulationModel
extends MonteCarloSimulationModel {
    default public RandomVariable getLIBOR(LocalDateTime date, LocalDateTime periodStartDate, LocalDateTime periodEndDate) throws CalculationException {
        LocalDateTime referenceDate = this.getReferenceDate();
        double time = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, date);
        double periodStart = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periodStartDate);
        double periodEnd = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periodEndDate);
        return this.getLIBOR(time, periodStart, periodEnd);
    }

    public RandomVariable getLIBOR(double var1, double var3, double var5) throws CalculationException;

    default public RandomVariable getNumeraire(LocalDateTime date) throws CalculationException {
        double time = FloatingpointDate.getFloatingPointDateFromDate(this.getReferenceDate(), date);
        return this.getNumeraire(time);
    }

    public RandomVariable getNumeraire(double var1) throws CalculationException;

    public ProcessModel getModel();

    public MonteCarloProcess getProcess();
}

