/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.LIBORModel;
import net.finmath.montecarlo.interestrate.ShortRateModel;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModel;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModelCalibrateable;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModelParametric;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.montecarlo.process.Process;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class HullWhiteModel
extends AbstractProcessModel
implements ShortRateModel,
LIBORModel,
Serializable {
    private static final long serialVersionUID = 8677410149401310062L;
    private static final Logger logger = Logger.getLogger("net.finmath");
    private final TimeDiscretization liborPeriodDiscretization;
    private String forwardCurveName;
    private final AnalyticModel analyticModel;
    private final ForwardCurve forwardRateCurve;
    private final DiscountCurve discountCurve;
    private final DiscountCurve discountCurveFromForwardCurve;
    private final RandomVariableFactory randomVariableFactory;
    private final ShortRateVolatilityModel volatilityModel;
    private final Map<String, Object> properties;
    private final boolean isInterpolateDiscountFactorsOnLiborPeriodDiscretization;
    private transient List<RandomVariable> numeraireDiscountFactors = new ArrayList<RandomVariable>();
    private transient List<RandomVariable> numeraireDiscountFactorForwardRates = new ArrayList<RandomVariable>();
    private transient List<RandomVariable> discountFactorFromForwardCurveCache = new ArrayList<RandomVariable>();
    private transient List<RandomVariable> forwardRateCache = new ArrayList<RandomVariable>();

    public HullWhiteModel(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, ShortRateVolatilityModel volatilityModel, Map<String, Object> properties) {
        this.randomVariableFactory = abstractRandomVariableFactory;
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.analyticModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.volatilityModel = volatilityModel;
        this.properties = new HashMap<String, Object>();
        if (properties != null) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                if (Serializable.class.isAssignableFrom(property.getValue().getClass())) {
                    properties.put(property.getKey(), property.getValue());
                    continue;
                }
                logger.warning("Ignored non serializable property under the key " + property.getKey() + ":" + property.getValue());
            }
        }
        this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization = (Boolean)this.properties.getOrDefault("isInterpolateDiscountFactorsOnLiborPeriodDiscretization", true);
        this.discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(forwardRateCurve);
    }

    public HullWhiteModel(TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, ShortRateVolatilityModel volatilityModel, Map<String, Object> properties) {
        this(new RandomVariableFromArrayFactory(), liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, volatilityModel, properties);
    }

    public static HullWhiteModel of(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, ShortRateVolatilityModel volatilityModel, CalibrationProduct[] calibrationProducts, Map<String, Object> properties) throws CalculationException {
        HullWhiteModel model = new HullWhiteModel(abstractRandomVariableFactory, liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, volatilityModel, properties);
        if (calibrationProducts != null && calibrationProducts.length > 0) {
            ShortRateVolatilityModelCalibrateable volatilityModelParametric = null;
            try {
                volatilityModelParametric = (ShortRateVolatilityModelCalibrateable)volatilityModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration restricted to covariance models implementing HullWhiteModelCalibrateable.");
            }
            Map calibrationParameters = null;
            if (properties != null && properties.containsKey("calibrationParameters")) {
                calibrationParameters = (Map)properties.get("calibrationParameters");
            }
            ShortRateVolatilityModelCalibrateable volatilityModelCalibrated = volatilityModelParametric.getCloneCalibrated(model, calibrationProducts, calibrationParameters);
            HullWhiteModel modelCalibrated = model.getCloneWithModifiedVolatilityModel(volatilityModelCalibrated);
            return modelCalibrated;
        }
        return model;
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return LocalDateTime.of(this.discountCurve.getReferenceDate(), LocalTime.of(0, 0));
    }

    @Override
    public int getNumberOfComponents() {
        return 2;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        RandomVariable zero = this.getRandomVariableForConstant(0.0);
        return new RandomVariable[]{zero, zero};
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) throws CalculationException {
        if (time < 0.0) {
            return this.randomVariableFactory.createRandomVariable(this.discountCurve.getDiscountFactor(this.analyticModel, time));
        }
        if (time == process.getTime(0)) {
            RandomVariable one = this.randomVariableFactory.createRandomVariable(1.0);
            return one;
        }
        int timeIndex = process.getTimeIndex(time);
        if (timeIndex < 0) {
            int previousTimeIndex = process.getTimeIndex(time);
            if (previousTimeIndex < 0) {
                previousTimeIndex = -previousTimeIndex - 1;
            }
            double previousTime = process.getTime(--previousTimeIndex);
            double nextTime = process.getTime(previousTimeIndex + 1);
            return this.getNumeraire(process, previousTime).log().mult(nextTime - time).add(this.getNumeraire(process, nextTime).log().mult(time - previousTime)).div(nextTime - previousTime).exp();
        }
        RandomVariable logNum = process.getProcessValue(timeIndex, 1).add(this.getV(0.0, time).mult(0.5));
        RandomVariable numeraireNormalized = logNum.exp();
        numeraireNormalized = numeraireNormalized.mult(numeraireNormalized.invert().getAverage());
        RandomVariable discountFactor = this.discountCurve != null ? this.getDiscountFactor(process, time).div(this.getDiscountFactorFromForwardCurve(process, time).getAverage()).mult(this.getDiscountFactorFromForwardCurve(process, time)) : this.getDiscountFactorFromForwardCurve(process, time);
        RandomVariable numeraire = numeraireNormalized.div(discountFactor);
        return numeraire;
    }

    @Override
    public RandomVariable getForwardDiscountBond(MonteCarloProcess process, double time, double maturity) throws CalculationException {
        RandomVariable inverseForwardBondAsOfTime = this.getLIBOR(process, time, time, maturity).mult(maturity - time).add(1.0);
        RandomVariable inverseForwardBondAsOfZero = this.getLIBOR(process, 0.0, time, maturity).mult(maturity - time).add(1.0);
        RandomVariable forwardDiscountBondAsOfZero = this.getDiscountFactor(process, maturity).div(this.getDiscountFactor(process, time));
        return forwardDiscountBondAsOfZero.mult(inverseForwardBondAsOfZero).div(inverseForwardBondAsOfTime);
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        double time = process.getTime(timeIndex);
        double timeNext = process.getTime(timeIndex + 1);
        if (timeNext == time) {
            return new RandomVariable[]{null, null};
        }
        int timeIndexVolatility = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexVolatility < 0) {
            timeIndexVolatility = -timeIndexVolatility - 2;
        }
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexVolatility);
        RandomVariable driftShortRate = realizationAtTimeIndex[0].mult(meanReversion.mult(this.getB(time, timeNext).div(-1.0 * (timeNext - time))));
        RandomVariable driftLogNumeraire = realizationAtTimeIndex[0].mult(this.getB(time, timeNext).div(timeNext - time));
        return new RandomVariable[]{driftShortRate, driftLogNumeraire};
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable factorLoading2;
        RandomVariable factorLoading1;
        double time = process.getTime(timeIndex);
        double timeNext = process.getTime(timeIndex + 1);
        int timeIndexVolatility = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexVolatility < 0) {
            timeIndexVolatility = -timeIndexVolatility - 2;
        }
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexVolatility);
        RandomVariable meanReversionTimesTime = meanReversion.mult(-2.0 * (timeNext - time));
        RandomVariable scaling = meanReversionTimesTime.exp().sub(1.0).div(meanReversionTimesTime).sqrt();
        RandomVariable volatilityEffective = scaling.mult(this.volatilityModel.getVolatility(timeIndexVolatility));
        if (componentIndex == 0) {
            factorLoading1 = volatilityEffective;
            factorLoading2 = new Scalar(0.0);
        } else if (componentIndex == 1) {
            RandomVariable volatilityLogNumeraire = this.getV(time, timeNext).div(timeNext - time).sqrt();
            RandomVariable rho = this.getDV(time, timeNext).div(timeNext - time).div(volatilityEffective.mult(volatilityLogNumeraire));
            factorLoading1 = volatilityLogNumeraire.mult(rho);
            factorLoading2 = volatilityLogNumeraire.mult(rho.squared().sub(1.0).mult(-1.0).sqrt());
        } else {
            throw new IllegalArgumentException();
        }
        return new RandomVariable[]{factorLoading1, factorLoading2};
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public RandomVariable getLIBOR(MonteCarloProcess process, double time, double periodStart, double periodEnd) throws CalculationException {
        return this.getZeroCouponBond(process, time, periodStart).div(this.getZeroCouponBond(process, time, periodEnd)).sub(1.0).div(periodEnd - periodStart);
    }

    @Override
    public RandomVariable getLIBOR(MonteCarloProcess process, int timeIndex, int liborIndex) throws CalculationException {
        return this.getZeroCouponBond(process, process.getTime(timeIndex), this.getLiborPeriod(liborIndex)).div(this.getZeroCouponBond(process, process.getTime(timeIndex), this.getLiborPeriod(liborIndex + 1))).sub(1.0).div(this.getLiborPeriodDiscretization().getTimeStep(liborIndex));
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public AnalyticModel getAnalyticModel() {
        return this.analyticModel;
    }

    @Override
    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurve getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    @Override
    public LIBORModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        if (dataModified == null) {
            return new HullWhiteModel(this.randomVariableFactory, this.liborPeriodDiscretization, this.analyticModel, this.forwardRateCurve, this.discountCurve, this.volatilityModel, this.properties);
        }
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        ShortRateVolatilityModel newVolatilityModel = (ShortRateVolatilityModel)dataModified.getOrDefault("volatilityModel", this.volatilityModel);
        return new HullWhiteModel(newRandomVariableFactory, this.liborPeriodDiscretization, this.analyticModel, this.forwardRateCurve, this.discountCurve, newVolatilityModel, this.properties);
    }

    private RandomVariable getShortRate(MonteCarloProcess process, int timeIndex) throws CalculationException {
        double time = process.getTime(timeIndex);
        double timePrev = timeIndex > 0 ? process.getTime(timeIndex - 1) : time;
        double timeNext = process.getTime(timeIndex + 1);
        RandomVariable zeroRate = this.getZeroRateFromForwardCurve(process, time);
        RandomVariable alpha = this.getDV(0.0, time);
        RandomVariable value = process.getProcessValue(timeIndex, 0);
        value = value.add(alpha);
        value = value.add(zeroRate);
        return value;
    }

    private RandomVariable getZeroCouponBond(MonteCarloProcess process, double time, double maturity) throws CalculationException {
        int timeIndex = process.getTimeIndex(time);
        if (timeIndex < 0) {
            int timeIndexLo = -timeIndex - 1 - 1;
            double timeLo = process.getTime(timeIndexLo);
            return this.getZeroCouponBond(process, timeLo, maturity).div(this.getZeroCouponBond(process, timeLo, time));
        }
        RandomVariable shortRate = this.getShortRate(process, timeIndex);
        RandomVariable A = this.getA(process, time, maturity);
        RandomVariable B = this.getB(time, maturity);
        return shortRate.mult(B.mult(-1.0)).exp().mult(A);
    }

    private RandomVariable getIntegratedDriftAdjustment(MonteCarloProcess process, int timeIndex) {
        RandomVariable integratedDriftAdjustment = new Scalar(0.0);
        for (int i = 1; i <= timeIndex; ++i) {
            double t = process.getTime(i - 1);
            double t2 = process.getTime(i);
            int timeIndexVolatilityModel = this.volatilityModel.getTimeDiscretization().getTimeIndex(t);
            if (timeIndexVolatilityModel < 0) {
                timeIndexVolatilityModel = -timeIndexVolatilityModel - 2;
            }
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexVolatilityModel);
            integratedDriftAdjustment = integratedDriftAdjustment.add(this.getShortRateConditionalVariance(0.0, t).mult(this.getB(t, t2))).sub(integratedDriftAdjustment.mult(meanReversion.mult(this.getB(t, t2))));
        }
        return integratedDriftAdjustment;
    }

    private RandomVariable getA(MonteCarloProcess process, double time, double maturity) {
        int timeIndex = process.getTimeIndex(time);
        double timeStep = process.getTimeDiscretization().getTimeStep(timeIndex);
        RandomVariable zeroRate = this.getZeroRateFromForwardCurve(process, time);
        RandomVariable forwardBond = this.getDiscountFactorFromForwardCurve(process, maturity).div(this.getDiscountFactorFromForwardCurve(process, time)).log();
        RandomVariable B = this.getB(time, maturity);
        RandomVariable lnA = B.mult(zeroRate).sub(B.squared().mult(this.getShortRateConditionalVariance(0.0, time).div(2.0))).add(forwardBond);
        return lnA.exp();
    }

    private RandomVariable getMRTime(double time, double maturity) {
        double timeNext;
        int timeIndexEnd;
        int timeIndexStart = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexStart < 0) {
            timeIndexStart = -timeIndexStart - 2;
        }
        if ((timeIndexEnd = this.volatilityModel.getTimeDiscretization().getTimeIndex(maturity)) < 0) {
            timeIndexEnd = -timeIndexEnd - 2;
        }
        RandomVariable integral = new Scalar(0.0);
        double timePrev = time;
        for (int timeIndex = timeIndexStart + 1; timeIndex <= timeIndexEnd; ++timeIndex) {
            timeNext = this.volatilityModel.getTimeDiscretization().getTime(timeIndex);
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndex - 1);
            integral = integral.add(meanReversion.mult(timeNext - timePrev));
            timePrev = timeNext;
        }
        timeNext = maturity;
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexEnd);
        integral = integral.add(meanReversion.mult(timeNext - timePrev));
        return integral;
    }

    private RandomVariable getB(double time, double maturity) {
        double timeNext;
        int timeIndexEnd;
        int timeIndexStart = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexStart < 0) {
            timeIndexStart = -timeIndexStart - 2;
        }
        if ((timeIndexEnd = this.volatilityModel.getTimeDiscretization().getTimeIndex(maturity)) < 0) {
            timeIndexEnd = -timeIndexEnd - 2;
        }
        RandomVariable integral = new Scalar(0.0);
        double timePrev = time;
        for (int timeIndex = timeIndexStart + 1; timeIndex <= timeIndexEnd; ++timeIndex) {
            timeNext = this.volatilityModel.getTimeDiscretization().getTime(timeIndex);
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndex - 1);
            integral = integral.add(this.getMRTime(timeNext, maturity).mult(-1.0).exp().sub(this.getMRTime(timePrev, maturity).mult(-1.0).exp()).div(meanReversion));
            timePrev = timeNext;
        }
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexEnd);
        timeNext = maturity;
        integral = integral.add(this.getMRTime(timeNext, maturity).mult(-1.0).exp().sub(this.getMRTime(timePrev, maturity).mult(-1.0).exp()).div(meanReversion));
        return integral;
    }

    private RandomVariable getV(double time, double maturity) {
        double timeNext;
        int timeIndexEnd;
        if (time == maturity) {
            return new Scalar(0.0);
        }
        int timeIndexStart = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexStart < 0) {
            timeIndexStart = -timeIndexStart - 2;
        }
        if ((timeIndexEnd = this.volatilityModel.getTimeDiscretization().getTimeIndex(maturity)) < 0) {
            timeIndexEnd = -timeIndexEnd - 2;
        }
        RandomVariable integral = new Scalar(0.0);
        double timePrev = time;
        RandomVariable expMRTimePrev = this.getMRTime(timePrev, maturity).mult(-1.0).exp();
        for (int timeIndex = timeIndexStart + 1; timeIndex <= timeIndexEnd; ++timeIndex) {
            timeNext = this.volatilityModel.getTimeDiscretization().getTime(timeIndex);
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndex - 1);
            RandomVariable volatility = this.volatilityModel.getVolatility(timeIndex - 1);
            RandomVariable volatilityPerMeanReversionSquared = volatility.squared().div(meanReversion.squared());
            RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-1.0).exp();
            integral = integral.add(volatilityPerMeanReversionSquared.mult(expMRTimeNext.sub(expMRTimePrev).mult(-2.0).div(meanReversion).add(expMRTimeNext.squared().sub(expMRTimePrev.squared()).div(meanReversion).div(2.0)).add(timeNext - timePrev)));
            timePrev = timeNext;
            expMRTimePrev = expMRTimeNext;
        }
        timeNext = maturity;
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexEnd);
        RandomVariable volatility = this.volatilityModel.getVolatility(timeIndexEnd);
        RandomVariable volatilityPerMeanReversionSquared = volatility.squared().div(meanReversion.squared());
        RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-1.0).exp();
        integral = integral.add(volatilityPerMeanReversionSquared.mult(expMRTimeNext.sub(expMRTimePrev).mult(-2.0).div(meanReversion).add(expMRTimeNext.squared().sub(expMRTimePrev.squared()).div(meanReversion).div(2.0)).add(timeNext - timePrev)));
        return integral;
    }

    private RandomVariable getDV(double time, double maturity) {
        double timeNext;
        int timeIndexEnd;
        if (time == maturity) {
            return new Scalar(0.0);
        }
        int timeIndexStart = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexStart < 0) {
            timeIndexStart = -timeIndexStart - 2;
        }
        if ((timeIndexEnd = this.volatilityModel.getTimeDiscretization().getTimeIndex(maturity)) < 0) {
            timeIndexEnd = -timeIndexEnd - 2;
        }
        RandomVariable integral = new Scalar(0.0);
        double timePrev = time;
        RandomVariable expMRTimePrev = this.getMRTime(timePrev, maturity).mult(-1.0).exp();
        for (int timeIndex = timeIndexStart + 1; timeIndex <= timeIndexEnd; ++timeIndex) {
            timeNext = this.volatilityModel.getTimeDiscretization().getTime(timeIndex);
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndex - 1);
            RandomVariable volatility = this.volatilityModel.getVolatility(timeIndex - 1);
            RandomVariable volatilityPerMeanReversionSquared = volatility.squared().div(meanReversion.squared());
            RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-1.0).exp();
            integral = integral.add(volatilityPerMeanReversionSquared.mult(expMRTimeNext.sub(expMRTimePrev).add(expMRTimeNext.squared().sub(expMRTimePrev.squared()).div(-2.0))));
            timePrev = timeNext;
            expMRTimePrev = expMRTimeNext;
        }
        timeNext = maturity;
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexEnd);
        RandomVariable volatility = this.volatilityModel.getVolatility(timeIndexEnd);
        RandomVariable volatilityPerMeanReversionSquared = volatility.squared().div(meanReversion.squared());
        RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-1.0).exp();
        integral = integral.add(volatilityPerMeanReversionSquared.mult(expMRTimeNext.sub(expMRTimePrev).add(expMRTimeNext.squared().sub(expMRTimePrev.squared()).div(-2.0))));
        return integral;
    }

    public RandomVariable getShortRateConditionalVariance(double time, double maturity) {
        double timeNext;
        int timeIndexEnd;
        int timeIndexStart = this.volatilityModel.getTimeDiscretization().getTimeIndex(time);
        if (timeIndexStart < 0) {
            timeIndexStart = -timeIndexStart - 2;
        }
        if ((timeIndexEnd = this.volatilityModel.getTimeDiscretization().getTimeIndex(maturity)) < 0) {
            timeIndexEnd = -timeIndexEnd - 2;
        }
        RandomVariable integral = new Scalar(0.0);
        double timePrev = time;
        RandomVariable expMRTimePrev = this.getMRTime(timePrev, maturity).mult(-2.0).exp();
        for (int timeIndex = timeIndexStart + 1; timeIndex <= timeIndexEnd; ++timeIndex) {
            timeNext = this.volatilityModel.getTimeDiscretization().getTime(timeIndex);
            RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndex - 1);
            RandomVariable volatility = this.volatilityModel.getVolatility(timeIndex - 1);
            RandomVariable volatilitySquaredPerMeanReversion = volatility.squared().div(meanReversion);
            RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-2.0).exp();
            integral = integral.add(volatilitySquaredPerMeanReversion.mult(expMRTimeNext.sub(expMRTimePrev).div(2.0)));
            timePrev = timeNext;
            expMRTimePrev = expMRTimeNext;
        }
        timeNext = maturity;
        RandomVariable meanReversion = this.volatilityModel.getMeanReversion(timeIndexEnd);
        RandomVariable volatility = this.volatilityModel.getVolatility(timeIndexEnd);
        RandomVariable volatilitySquaredPerMeanReversion = volatility.squared().div(meanReversion);
        RandomVariable expMRTimeNext = this.getMRTime(timeNext, maturity).mult(-2.0).exp();
        integral = integral.add(volatilitySquaredPerMeanReversion.mult(expMRTimeNext.sub(expMRTimePrev).div(2.0)));
        return integral;
    }

    public RandomVariable getIntegratedBondSquaredVolatility(double time, double maturity) {
        return this.getShortRateConditionalVariance(0.0, time).mult(this.getB(time, maturity).squared());
    }

    @Override
    public HullWhiteModel getCloneWithModifiedVolatilityModel(ShortRateVolatilityModel volatilityModel) {
        return new HullWhiteModel(this.randomVariableFactory, this.liborPeriodDiscretization, this.analyticModel, this.forwardRateCurve, this.discountCurve, volatilityModel, this.properties);
    }

    @Override
    public ShortRateVolatilityModel getVolatilityModel() {
        return this.volatilityModel;
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        int timeIndex;
        Process process = null;
        TreeMap<String, RandomVariable> modelParameters = new TreeMap<String, RandomVariable>();
        TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
        for (timeIndex = 0; timeIndex < timeDiscretizationForCurves.getNumberOfTimes() - 1; ++timeIndex) {
            modelParameters.put("FORWARDRATE(" + timeDiscretizationForCurves.getTime(timeIndex) + ")", this.getForwardRateInitialValue((MonteCarloProcess)process, timeIndex));
        }
        if (this.volatilityModel instanceof ShortRateVolatilityModelParametric) {
            RandomVariable[] parameters = ((ShortRateVolatilityModelParametric)this.volatilityModel).getParameter();
            for (int volatilityModelParameterIndex = 0; volatilityModelParameterIndex < parameters.length; ++volatilityModelParameterIndex) {
                modelParameters.put("VOLATILITYMODELPARAMETER(" + volatilityModelParameterIndex + ")", parameters[volatilityModelParameterIndex]);
            }
        }
        for (timeIndex = 0; timeIndex < timeDiscretizationForCurves.getNumberOfTimes() - 1; ++timeIndex) {
            modelParameters.put("NUMERAIREADJUSTMENTFORWARD(" + timeDiscretizationForCurves.getTime(timeIndex) + ")", this.numeraireDiscountFactorForwardRates.get(timeIndex));
        }
        return modelParameters;
    }

    private RandomVariable getDiscountFactor(MonteCarloProcess process, double time) {
        TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
        int timeIndex = timeDiscretizationForCurves.getTimeIndex(time);
        if (timeIndex >= 0) {
            return this.getDiscountFactor(process, timeIndex);
        }
        int timeIndexPrev = Math.min(-timeIndex - 2, this.getLiborPeriodDiscretization().getNumberOfTimes() - 2);
        int timeIndexNext = timeIndexPrev + 1;
        double timePrev = timeDiscretizationForCurves.getTime(timeIndexPrev);
        double timeNext = timeDiscretizationForCurves.getTime(timeIndexNext);
        RandomVariable discountFactorPrev = this.getDiscountFactor(process, timeIndexPrev);
        RandomVariable discountFactorNext = this.getDiscountFactor(process, timeIndexNext);
        return discountFactorPrev.mult(discountFactorNext.div(discountFactorPrev).pow((time - timePrev) / (timeNext - timePrev)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getDiscountFactor(MonteCarloProcess process, int timeIndex) {
        TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
        double time = timeDiscretizationForCurves.getTime(timeIndex);
        List<RandomVariable> list = this.numeraireDiscountFactorForwardRates;
        synchronized (list) {
            if (this.numeraireDiscountFactors.size() == 0) {
                double dfInitial = this.discountCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(0));
                RandomVariable deterministicNumeraireAdjustment = this.randomVariableFactory.createRandomVariable(dfInitial);
                this.numeraireDiscountFactors.add(0, deterministicNumeraireAdjustment);
                for (int i = 0; i < timeDiscretizationForCurves.getNumberOfTimeSteps(); ++i) {
                    double dfPrev = this.discountCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(i));
                    double dfNext = this.discountCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(i + 1));
                    double timeStep = timeDiscretizationForCurves.getTimeStep(i);
                    double timeNext = timeDiscretizationForCurves.getTime(i + 1);
                    RandomVariable forwardRate = this.randomVariableFactory.createRandomVariable((dfPrev / dfNext - 1.0) / timeStep);
                    this.numeraireDiscountFactorForwardRates.add(i, forwardRate);
                    deterministicNumeraireAdjustment = deterministicNumeraireAdjustment.discount(forwardRate, timeStep);
                    this.numeraireDiscountFactors.add(i + 1, deterministicNumeraireAdjustment);
                }
            }
            RandomVariable deterministicNumeraireAdjustment = this.numeraireDiscountFactors.get(timeIndex);
            return deterministicNumeraireAdjustment;
        }
    }

    private RandomVariable getZeroRateFromForwardCurve(MonteCarloProcess process, double time) {
        TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
        int timeIndex = timeDiscretizationForCurves.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = Math.min(-timeIndex - 2, this.getLiborPeriodDiscretization().getNumberOfTimes() - 2);
        }
        double timeStep = timeDiscretizationForCurves.getTimeStep(timeIndex);
        return this.getDiscountFactorFromForwardCurve(process, timeIndex).div(this.getDiscountFactorFromForwardCurve(process, timeIndex)).log().div(timeStep);
    }

    private RandomVariable getDiscountFactorFromForwardCurve(MonteCarloProcess process, double time) {
        TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
        int timeIndex = timeDiscretizationForCurves.getTimeIndex(time);
        if (timeIndex >= 0) {
            return this.getDiscountFactorFromForwardCurve(process, timeIndex);
        }
        int timeIndexPrev = Math.min(-timeIndex - 2, this.getLiborPeriodDiscretization().getNumberOfTimes() - 2);
        int timeIndexNext = timeIndexPrev + 1;
        double timePrev = timeDiscretizationForCurves.getTime(timeIndexPrev);
        double timeNext = timeDiscretizationForCurves.getTime(timeIndexNext);
        RandomVariable discountFactorPrev = this.getDiscountFactorFromForwardCurve(process, timeIndexPrev);
        RandomVariable discountFactorNext = this.getDiscountFactorFromForwardCurve(process, timeIndexNext);
        return discountFactorPrev.mult(discountFactorNext.div(discountFactorPrev).pow((time - timePrev) / (timeNext - timePrev)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getDiscountFactorFromForwardCurve(MonteCarloProcess process, int timeIndex) {
        List<RandomVariable> list = this.discountFactorFromForwardCurveCache;
        synchronized (list) {
            if (this.discountFactorFromForwardCurveCache.size() <= timeIndex) {
                TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
                for (int i = this.discountFactorFromForwardCurveCache.size(); i <= timeIndex; ++i) {
                    RandomVariable dfAsRandomVariable;
                    if (i == 0) {
                        double df = this.discountCurveFromForwardCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(i));
                        dfAsRandomVariable = this.randomVariableFactory.createRandomVariable(df);
                    } else {
                        RandomVariable dfPrevious = this.discountFactorFromForwardCurveCache.get(i - 1);
                        RandomVariable forwardRate = this.getForwardRateInitialValue(process, i - 1);
                        dfAsRandomVariable = dfPrevious.div(forwardRate.mult(timeDiscretizationForCurves.getTimeStep(i - 1)).add(1.0));
                    }
                    this.discountFactorFromForwardCurveCache.add(dfAsRandomVariable);
                }
            }
        }
        return this.discountFactorFromForwardCurveCache.get(timeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getForwardRateInitialValue(MonteCarloProcess process, int timeIndex) {
        List<RandomVariable> list = this.forwardRateCache;
        synchronized (list) {
            if (this.forwardRateCache.size() <= timeIndex) {
                TimeDiscretization timeDiscretizationForCurves = this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization ? this.liborPeriodDiscretization : process.getTimeDiscretization();
                for (int i = this.forwardRateCache.size(); i <= timeIndex; ++i) {
                    double dfPrev = this.discountCurveFromForwardCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(i));
                    double dfNext = this.discountCurveFromForwardCurve.getDiscountFactor(this.analyticModel, timeDiscretizationForCurves.getTime(i + 1));
                    RandomVariable forwardRate = this.randomVariableFactory.createRandomVariable((dfPrev / dfNext - 1.0) / timeDiscretizationForCurves.getTimeStep(i));
                    this.forwardRateCache.add(forwardRate);
                }
            }
        }
        return this.forwardRateCache.get(timeIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.numeraireDiscountFactors = new ArrayList<RandomVariable>();
        this.numeraireDiscountFactorForwardRates = new ArrayList<RandomVariable>();
        this.discountFactorFromForwardCurveCache = new ArrayList<RandomVariable>();
        this.forwardRateCache = new ArrayList<RandomVariable>();
    }

    public String toString() {
        return "HullWhiteModel [liborPeriodDiscretization=" + this.liborPeriodDiscretization + ", forwardCurveName=" + this.forwardCurveName + ", analyticModel=" + this.analyticModel + ", forwardRateCurve=" + this.forwardRateCurve + ", discountCurve=" + this.discountCurve + ", discountCurveFromForwardCurve=" + this.discountCurveFromForwardCurve + ", randomVariableFactory=" + this.randomVariableFactory + ", volatilityModel=" + this.volatilityModel + ", properties=" + this.properties + ", isInterpolateDiscountFactorsOnLiborPeriodDiscretization=" + this.isInterpolateDiscountFactorsOnLiborPeriodDiscretization + "]";
    }
}

