/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORCorrelationModelExponentialDecay
extends LIBORCorrelationModel {
    private static final long serialVersionUID = -8218022418731667531L;
    private final int numberOfFactors;
    private final double a;
    private final boolean isCalibrateable;
    private double[][] correlationMatrix;
    private double[][] factorMatrix;

    public LIBORCorrelationModelExponentialDecay(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, double a, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.isCalibrateable = isCalibrateable;
        this.initialize(numberOfFactors, a);
    }

    public LIBORCorrelationModelExponentialDecay(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, double a) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.isCalibrateable = false;
        this.initialize(numberOfFactors, a);
    }

    @Override
    public LIBORCorrelationModelExponentialDecay getCloneWithModifiedParameter(RandomVariable[] parameter) {
        if (!this.isCalibrateable) {
            return this;
        }
        return new LIBORCorrelationModelExponentialDecay(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.numberOfFactors, parameter[0].doubleValue());
    }

    @Override
    public Object clone() {
        return new LIBORCorrelationModelExponentialDecay(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.numberOfFactors, this.a, this.isCalibrateable);
    }

    @Override
    public double getFactorLoading(int timeIndex, int factor, int component) {
        return this.factorMatrix[component][factor];
    }

    @Override
    public double getCorrelation(int timeIndex, int component1, int component2) {
        return this.correlationMatrix[component1][component2];
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorMatrix[0].length;
    }

    private void initialize(int numberOfFactors, double a) {
        a = Math.max(a, 0.0);
        this.correlationMatrix = new double[this.getLiborPeriodDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
        for (int row = 0; row < this.correlationMatrix.length; ++row) {
            for (int col = 0; col < this.correlationMatrix[row].length; ++col) {
                this.correlationMatrix[row][col] = Math.exp(-a * Math.abs(this.getLiborPeriodDiscretization().getTime(row) - this.getLiborPeriodDiscretization().getTime(col)));
            }
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, numberOfFactors);
        for (int component1 = 0; component1 < this.factorMatrix.length; ++component1) {
            for (int component2 = 0; component2 < component1; ++component2) {
                double correlation = 0.0;
                for (int factor = 0; factor < this.factorMatrix[component1].length; ++factor) {
                    correlation += this.factorMatrix[component1][factor] * this.factorMatrix[component2][factor];
                }
                this.correlationMatrix[component1][component2] = correlation;
                this.correlationMatrix[component2][component1] = correlation;
            }
            this.correlationMatrix[component1][component1] = 1.0;
        }
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[]{new Scalar(this.a)};
        return parameter;
    }

    @Override
    public LIBORCorrelationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        int numberOfFactors = this.getNumberOfFactors();
        double a = this.a;
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            numberOfFactors = (Integer)dataModified.getOrDefault("numberOfFactors", numberOfFactors);
            a = (Double)dataModified.getOrDefault("a", a);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
        }
        LIBORCorrelationModelExponentialDecay newModel = new LIBORCorrelationModelExponentialDecay(timeDiscretization, liborPeriodDiscretization, numberOfFactors, a, isCalibrateable);
        return newModel;
    }
}

