/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORCorrelationModelThreeParameterExponentialDecay
extends LIBORCorrelationModel {
    private static final long serialVersionUID = 5063076041285957177L;
    private final int numberOfFactors;
    private final double a;
    private final double b;
    private final double c;
    private final boolean isCalibrateable;
    private final Object lazyInitLock = new Object();
    private transient double[][] correlationMatrix;
    private transient double[][] factorMatrix;

    public LIBORCorrelationModelThreeParameterExponentialDecay(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, double a, double b, double c, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.b = b;
        this.c = c;
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[]{new Scalar(this.a), new Scalar(this.b), new Scalar(this.c)};
        return parameter;
    }

    @Override
    public LIBORCorrelationModelThreeParameterExponentialDecay getCloneWithModifiedParameter(RandomVariable[] parameter) {
        if (!this.isCalibrateable) {
            return this;
        }
        return new LIBORCorrelationModelThreeParameterExponentialDecay(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameter[0].doubleValue(), parameter[1].doubleValue(), parameter[2].doubleValue(), this.isCalibrateable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getFactorLoading(int timeIndex, int factor, int component) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.factorMatrix == null) {
                this.initialize(this.numberOfFactors, this.a, this.b, this.c);
            }
        }
        return this.factorMatrix[component][factor];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getCorrelation(int timeIndex, int component1, int component2) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.correlationMatrix == null) {
                this.initialize(this.numberOfFactors, this.a, this.b, this.c);
            }
        }
        return this.correlationMatrix[component1][component2];
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    private void initialize(int numberOfFactors, double a, double b, double c) {
        a = Math.max(a, 0.0);
        b = Math.min(Math.max(b, 0.0), 1.0);
        c = Math.max(c, 0.0);
        this.correlationMatrix = new double[this.getLiborPeriodDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
        for (int row = 0; row < this.correlationMatrix.length; ++row) {
            for (int col = row + 1; col < this.correlationMatrix[row].length; ++col) {
                double correlation;
                double T1 = this.getLiborPeriodDiscretization().getTime(row);
                double T2 = this.getLiborPeriodDiscretization().getTime(col);
                this.correlationMatrix[row][col] = correlation = b + (1.0 - b) * Math.exp(-a * Math.abs(T1 - T2) - c * Math.max(T1, T2));
                this.correlationMatrix[col][row] = correlation;
            }
            this.correlationMatrix[row][row] = 1.0;
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, numberOfFactors);
        for (int component1 = 0; component1 < this.factorMatrix.length; ++component1) {
            for (int component2 = component1 + 1; component2 < this.factorMatrix.length; ++component2) {
                double correlation = 0.0;
                for (int factor = 0; factor < this.factorMatrix[component1].length; ++factor) {
                    correlation += this.factorMatrix[component1][factor] * this.factorMatrix[component2][factor];
                }
                this.correlationMatrix[component1][component2] = correlation;
                this.correlationMatrix[component2][component1] = correlation;
            }
            this.correlationMatrix[component1][component1] = 1.0;
        }
    }

    @Override
    public Object clone() {
        this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        LIBORCorrelationModelThreeParameterExponentialDecay newModel = new LIBORCorrelationModelThreeParameterExponentialDecay(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.numberOfFactors, this.a, this.b, this.c, this.isCalibrateable);
        newModel.correlationMatrix = this.correlationMatrix;
        newModel.factorMatrix = this.factorMatrix;
        return newModel;
    }

    @Override
    public LIBORCorrelationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        int numberOfFactors = this.getNumberOfFactors();
        double a = this.a;
        double b = this.b;
        double c = this.c;
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            numberOfFactors = (Integer)dataModified.getOrDefault("numberOfFactors", numberOfFactors);
            a = (Double)dataModified.getOrDefault("a", a);
            b = (Double)dataModified.getOrDefault("a", b);
            c = (Double)dataModified.getOrDefault("a", c);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
        }
        LIBORCorrelationModelThreeParameterExponentialDecay newModel = new LIBORCorrelationModelThreeParameterExponentialDecay(timeDiscretization, liborPeriodDiscretization, numberOfFactors, a, b, c, isCalibrateable);
        return newModel;
    }
}

