/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Arrays;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModelFourParameterExponentialForm;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORCovarianceModelExponentialForm5Param
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -6538642489767323201L;
    private RandomVariable[] parameter = new RandomVariable[5];
    private LIBORVolatilityModel volatilityModel;
    private LIBORCorrelationModel correlationModel;

    public LIBORCovarianceModelExponentialForm5Param(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, RandomVariable[] parameters) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter = (RandomVariable[])parameters.clone();
        this.volatilityModel = new LIBORVolatilityModelFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.parameter[0], this.parameter[1], this.parameter[2], this.parameter[3], false);
        this.correlationModel = new LIBORCorrelationModelExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.parameter[4].doubleValue(), false);
    }

    public LIBORCovarianceModelExponentialForm5Param(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, double[] parameters) {
        this(timeDiscretization, liborPeriodDiscretization, numberOfFactors, Scalar.arrayOf(parameters));
    }

    public LIBORCovarianceModelExponentialForm5Param(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors) {
        this(timeDiscretization, liborPeriodDiscretization, numberOfFactors, new double[]{0.2, 0.05, 0.1, 0.2, 0.1});
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelExponentialForm5Param model = new LIBORCovarianceModelExponentialForm5Param(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.getParameter());
        model.parameter = this.parameter;
        model.volatilityModel = this.volatilityModel;
        model.correlationModel = this.correlationModel;
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        LIBORCovarianceModelExponentialForm5Param model = (LIBORCovarianceModelExponentialForm5Param)this.clone();
        model.parameter = parameters;
        if (parameters[0] != this.parameter[0] || parameters[1] != this.parameter[1] || parameters[2] != this.parameter[2] || parameters[3] != this.parameter[3]) {
            model.volatilityModel = new LIBORVolatilityModelFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameters[0], parameters[1], parameters[2], parameters[3], false);
        }
        if (parameters[4] != this.parameter[4]) {
            model.correlationModel = new LIBORCorrelationModelExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameters[4].doubleValue(), false);
        }
        return model;
    }

    @Override
    public RandomVariable[] getParameter() {
        return (RandomVariable[])this.parameter.clone();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = new RandomVariable[this.correlationModel.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            RandomVariable volatility = this.volatilityModel.getVolatility(timeIndex, component);
            factorLoading[factorIndex] = volatility.mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariableFromDoubleArray getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        int numberOfFactors = this.getNumberOfFactors();
        RandomVariable[] parameter = this.parameter;
        RandomVariableFactory abstractRandomVariableFactory = null;
        if (dataModified != null) {
            if (dataModified.containsKey("randomVariableFactory")) {
                abstractRandomVariableFactory = (RandomVariableFactory)dataModified.get("randomVariableFactory");
                parameter = abstractRandomVariableFactory.createRandomVariableArray(Arrays.stream(parameter).mapToDouble(new ToDoubleFunction<RandomVariable>(){

                    @Override
                    public double applyAsDouble(RandomVariable para) {
                        return para.doubleValue();
                    }
                }).toArray());
            }
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            numberOfFactors = (Integer)dataModified.getOrDefault("numberOfFactors", numberOfFactors);
            parameter = dataModified.getOrDefault("parameter", parameter) instanceof RandomVariable[] ? (RandomVariable[])dataModified.getOrDefault("parameter", parameter) : (abstractRandomVariableFactory == null ? Scalar.arrayOf((double[])dataModified.get("parameter")) : abstractRandomVariableFactory.createRandomVariableArray((double[])dataModified.get("parameter")));
        }
        LIBORCovarianceModelExponentialForm5Param newModel = new LIBORCovarianceModelExponentialForm5Param(timeDiscretization, liborPeriodDiscretization, numberOfFactors, parameter);
        return newModel;
    }
}

