/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Arrays;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORCovarianceModelFromVolatilityAndCorrelation
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -8782024526695367005L;
    private final LIBORVolatilityModel volatilityModel;
    private final LIBORCorrelationModel correlationModel;

    public LIBORCovarianceModelFromVolatilityAndCorrelation(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, LIBORVolatilityModel volatilityModel, LIBORCorrelationModel correlationModel) {
        super(timeDiscretization, liborPeriodDiscretization, correlationModel.getNumberOfFactors());
        this.volatilityModel = volatilityModel;
        this.correlationModel = correlationModel;
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = new RandomVariable[this.correlationModel.getNumberOfFactors()];
        RandomVariable volatility = this.volatilityModel.getVolatility(timeIndex, component);
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            factorLoading[factorIndex] = volatility.mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable factorLoadingPseudoInverse = this.volatilityModel.getVolatility(timeIndex, component).invert().mult(this.correlationModel.getFactorLoading(timeIndex, factor, component));
        int numberOfComponents = this.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        double factorWeight = 0.0;
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            double factorElement = this.correlationModel.getFactorLoading(timeIndex, factor, componentIndex);
            factorWeight += factorElement * factorElement;
        }
        factorLoadingPseudoInverse = factorLoadingPseudoInverse.mult(1.0 / factorWeight);
        return factorLoadingPseudoInverse;
    }

    @Override
    public RandomVariable getCovariance(int timeIndex, int component1, int component2, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable volatilityOfComponent1 = this.volatilityModel.getVolatility(timeIndex, component1);
        RandomVariable volatilityOfComponent2 = this.volatilityModel.getVolatility(timeIndex, component2);
        double correlationOfComponent1And2 = this.correlationModel.getCorrelation(timeIndex, component1, component2);
        RandomVariable covariance = volatilityOfComponent1.mult(volatilityOfComponent2).mult(correlationOfComponent1And2);
        return covariance;
    }

    @Override
    public RandomVariable[] getParameter() {
        RandomVariable[] volatilityParameter = this.volatilityModel.getParameter();
        RandomVariable[] correlationParameter = this.correlationModel.getParameter();
        int parameterLength = 0;
        parameterLength += volatilityParameter != null ? volatilityParameter.length : 0;
        RandomVariable[] parameter = new RandomVariable[parameterLength += correlationParameter != null ? correlationParameter.length : 0];
        int parameterIndex = 0;
        if (volatilityParameter != null) {
            System.arraycopy(volatilityParameter, 0, parameter, parameterIndex, volatilityParameter.length);
            parameterIndex += volatilityParameter.length;
        }
        if (correlationParameter != null) {
            System.arraycopy(correlationParameter, 0, parameter, parameterIndex, correlationParameter.length);
            parameterIndex += correlationParameter.length;
        }
        return parameter;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public Object clone() {
        return new LIBORCovarianceModelFromVolatilityAndCorrelation(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), (LIBORVolatilityModel)this.volatilityModel.clone(), (LIBORCorrelationModel)this.correlationModel.clone());
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        LIBORVolatilityModel volatilityModel = this.volatilityModel;
        LIBORCorrelationModel correlationModel = this.correlationModel;
        RandomVariable[] volatilityParameter = volatilityModel.getParameter();
        RandomVariable[] correlationParameter = correlationModel.getParameter();
        int parameterIndex = 0;
        if (volatilityParameter != null) {
            Object[] newVolatilityParameter = new RandomVariable[volatilityParameter.length];
            System.arraycopy(parameters, parameterIndex, newVolatilityParameter, 0, newVolatilityParameter.length);
            parameterIndex += newVolatilityParameter.length;
            if (!Arrays.equals(newVolatilityParameter, volatilityModel.getParameter())) {
                volatilityModel = volatilityModel.getCloneWithModifiedParameter((RandomVariable[])newVolatilityParameter);
            }
        }
        if (correlationParameter != null) {
            Object[] newCorrelationParameter = new RandomVariable[correlationParameter.length];
            System.arraycopy(parameters, parameterIndex, newCorrelationParameter, 0, newCorrelationParameter.length);
            parameterIndex += newCorrelationParameter.length;
            if (!Arrays.equals(newCorrelationParameter, correlationModel.getParameter())) {
                correlationModel = correlationModel.getCloneWithModifiedParameter((RandomVariable[])newCorrelationParameter);
            }
        }
        return new LIBORCovarianceModelFromVolatilityAndCorrelation(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), volatilityModel, correlationModel);
    }

    public LIBORVolatilityModel getVolatilityModel() {
        return this.volatilityModel;
    }

    public LIBORCorrelationModel getCorrelationModel() {
        return this.correlationModel;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        LIBORVolatilityModel volatilityModel = this.volatilityModel;
        LIBORCorrelationModel correlationModel = this.correlationModel;
        if (dataModified != null) {
            if (dataModified.containsKey("timeDiscretization") || dataModified.containsKey("liborPeriodDiscretization") || dataModified.containsKey("randomVariableFactory")) {
                if (!dataModified.containsKey("volatilityModel")) {
                    volatilityModel = volatilityModel.getCloneWithModifiedData(dataModified);
                }
                if (!dataModified.containsKey("correlationModel")) {
                    correlationModel = correlationModel.getCloneWithModifiedData(dataModified);
                }
            }
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            volatilityModel = (LIBORVolatilityModel)dataModified.getOrDefault("volatilityModel", volatilityModel);
            correlationModel = (LIBORCorrelationModel)dataModified.getOrDefault("correlationModel", correlationModel);
        }
        LIBORCovarianceModelFromVolatilityAndCorrelation newModel = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretization, liborPeriodDiscretization, volatilityModel, correlationModel);
        return newModel;
    }
}

