/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class LIBORCovarianceModelStochasticVolatility
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -559341617850035368L;
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private final BrownianMotion brownianMotion;
    private RandomVariable rho;
    private RandomVariable nu;
    private boolean isCalibrateable = false;
    private MonteCarloProcess stochasticVolatilityScalings = null;

    public LIBORCovarianceModelStochasticVolatility(AbstractLIBORCovarianceModelParametric covarianceModel, BrownianMotion brownianMotion, RandomVariable nu, RandomVariable rho, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.brownianMotion = brownianMotion;
        this.nu = nu;
        this.rho = rho;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORCovarianceModelStochasticVolatility(AbstractLIBORCovarianceModelParametric covarianceModel, BrownianMotion brownianMotion, double nu, double rho, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.brownianMotion = brownianMotion;
        this.nu = new Scalar(nu);
        this.rho = new Scalar(rho);
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        RandomVariable[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new RandomVariable[]{this.nu, this.rho};
        }
        RandomVariable[] jointParameters = new RandomVariable[covarianceParameters.length + 2];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length + 0] = this.nu;
        jointParameters[covarianceParameters.length + 1] = this.rho;
        return jointParameters;
    }

    private void setParameter(RandomVariable[] parameter) {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameter);
            return;
        }
        RandomVariable[] covarianceParameters = new RandomVariable[parameter.length - 2];
        System.arraycopy(parameter, 0, covarianceParameters, 0, covarianceParameters.length);
        this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        this.nu = parameter[covarianceParameters.length + 0];
        this.rho = parameter[covarianceParameters.length + 1];
        this.stochasticVolatilityScalings = null;
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelStochasticVolatility newModel = new LIBORCovarianceModelStochasticVolatility((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.brownianMotion, this.nu, this.rho, this.isCalibrateable);
        return newModel;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        LIBORCovarianceModelStochasticVolatility model = (LIBORCovarianceModelStochasticVolatility)this.clone();
        model.setParameter(parameters);
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        LIBORCovarianceModelStochasticVolatility lIBORCovarianceModelStochasticVolatility = this;
        synchronized (lIBORCovarianceModelStochasticVolatility) {
            if (this.stochasticVolatilityScalings == null) {
                ProcessModel model = new ProcessModel(){

                    @Override
                    public LocalDateTime getReferenceDate() {
                        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
                    }

                    @Override
                    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumberOfFactors() {
                        return 2;
                    }

                    @Override
                    public int getNumberOfComponents() {
                        return 1;
                    }

                    @Override
                    public RandomVariable[] getInitialState(MonteCarloProcess process) {
                        return new RandomVariable[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(0.0)};
                    }

                    @Override
                    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
                        return new RandomVariable[]{LIBORCovarianceModelStochasticVolatility.this.nu.squared().mult(-0.5)};
                    }

                    @Override
                    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
                        return new RandomVariable[]{LIBORCovarianceModelStochasticVolatility.this.rho.mult(LIBORCovarianceModelStochasticVolatility.this.nu), LIBORCovarianceModelStochasticVolatility.this.rho.squared().sub(1.0).mult(-1.0).sqrt().mult(LIBORCovarianceModelStochasticVolatility.this.nu)};
                    }

                    @Override
                    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
                        return randomVariable.exp();
                    }

                    @Override
                    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
                        return randomVariable.log();
                    }

                    @Override
                    public RandomVariable getRandomVariableForConstant(double value) {
                        throw new UnsupportedOperationException("Method not implemented");
                    }

                    @Override
                    public ProcessModel getCloneWithModifiedData(Map<String, Object> dataModified) {
                        throw new UnsupportedOperationException("Method not implemented");
                    }
                };
                this.stochasticVolatilityScalings = new EulerSchemeFromProcessModel(model, this.brownianMotion);
            }
        }
        RandomVariable stochasticVolatilityScaling = null;
        try {
            stochasticVolatilityScaling = this.stochasticVolatilityScalings.getProcessValue(timeIndex, 0);
        }
        catch (CalculationException model) {
            // empty catch block
        }
        RandomVariable[] factorLoading = null;
        if (stochasticVolatilityScaling != null) {
            factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
            for (int i = 0; i < factorLoading.length; ++i) {
                factorLoading[i] = factorLoading[i].mult(stochasticVolatilityScaling);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        return null;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        BrownianMotion brownianMotion = this.brownianMotion;
        RandomVariable nu = this.nu;
        RandomVariable rho = this.rho;
        boolean isCalibrateable = this.isCalibrateable;
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        RandomVariableFactory abstractRandomVariableFactory = null;
        if (dataModified != null) {
            if (dataModified.containsKey("randomVariableFactory")) {
                abstractRandomVariableFactory = (RandomVariableFactory)dataModified.get("randomVariableFactory");
                nu = abstractRandomVariableFactory.createRandomVariable(nu.doubleValue());
                rho = abstractRandomVariableFactory.createRandomVariable(rho.doubleValue());
            }
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            brownianMotion = (BrownianMotion)dataModified.getOrDefault("brownianMotion", brownianMotion);
            nu = dataModified.getOrDefault("nu", nu) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("nu", nu) : (abstractRandomVariableFactory == null ? new Scalar((Double)dataModified.get("nu")) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("nu")));
            rho = dataModified.getOrDefault("rho", rho) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("rho", rho) : (abstractRandomVariableFactory == null ? new Scalar((Double)dataModified.get("rho")) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("rho")));
        }
        LIBORCovarianceModelStochasticVolatility newModel = new LIBORCovarianceModelStochasticVolatility(covarianceModel, brownianMotion, nu, rho, isCalibrateable);
        return newModel;
    }
}

