/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelFourParameterExponentialForm
extends LIBORVolatilityModel {
    private static final long serialVersionUID = -7371483471144264848L;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final RandomVariable a;
    private final RandomVariable b;
    private final RandomVariable c;
    private final RandomVariable d;
    private boolean isCalibrateable = false;
    private transient RandomVariable[][] volatility;
    private transient Object volatilityLazyInitLock = new Object();

    public LIBORVolatilityModelFourParameterExponentialForm(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable a, RandomVariable b, RandomVariable c, RandomVariable d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFourParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable a, RandomVariable b, RandomVariable c, RandomVariable d, boolean isCalibrateable) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, a, b, c, d, isCalibrateable);
    }

    public LIBORVolatilityModelFourParameterExponentialForm(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.a = abstractRandomVariableFactory.createRandomVariable(a);
        this.b = abstractRandomVariableFactory.createRandomVariable(b);
        this.c = abstractRandomVariableFactory.createRandomVariable(c);
        this.d = abstractRandomVariableFactory.createRandomVariable(d);
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFourParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, a, b, c, d, isCalibrateable);
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public LIBORVolatilityModelFourParameterExponentialForm getCloneWithModifiedParameter(RandomVariable[] parameter) {
        if (!this.isCalibrateable) {
            return this;
        }
        return new LIBORVolatilityModelFourParameterExponentialForm(this.abstractRandomVariableFactory, this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameter[0], parameter[1], parameter[2], parameter[3], this.isCalibrateable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        Object object = this.volatilityLazyInitLock;
        synchronized (object) {
            if (this.volatility == null) {
                this.volatility = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
            }
            if (this.volatility[timeIndex][liborIndex] == null) {
                double time = this.getTimeDiscretization().getTime(timeIndex);
                double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
                double timeToMaturity = maturity - time;
                RandomVariable volatilityInstanteaneous = timeToMaturity <= 0.0 ? this.abstractRandomVariableFactory.createRandomVariable(0.0) : this.a.addProduct(this.b, timeToMaturity).mult(this.c.mult(-timeToMaturity).exp()).add(this.d);
                this.volatility[timeIndex][liborIndex] = volatilityInstanteaneous;
            }
            return this.volatility[timeIndex][liborIndex];
        }
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialForm(this.abstractRandomVariableFactory, super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory abstractRandomVariableFactory = this.abstractRandomVariableFactory;
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        RandomVariable a = this.a;
        RandomVariable b = this.b;
        RandomVariable c = this.c;
        RandomVariable d = this.d;
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            abstractRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", abstractRandomVariableFactory);
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            a = dataModified.getOrDefault("a", a) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("a", a)).doubleValue()) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("a"));
            b = dataModified.getOrDefault("b", b) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("b", b)).doubleValue()) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("b"));
            c = dataModified.getOrDefault("c", c) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("c", c)).doubleValue()) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("c"));
            d = dataModified.getOrDefault("d", d) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("d", d)).doubleValue()) : abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("d"));
        }
        LIBORVolatilityModelFourParameterExponentialForm newModel = new LIBORVolatilityModelFourParameterExponentialForm(abstractRandomVariableFactory, timeDiscretization, liborPeriodDiscretization, a, b, c, d, isCalibrateable);
        return newModel;
    }
}

