/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelFourParameterExponentialFormIntegrated
extends LIBORVolatilityModel {
    private static final long serialVersionUID = -1613728266481870311L;
    private final double[] coeffTaylorE1 = new double[]{1.0, 0.5, 0.16666666666666666, 0.041666666666666664, 0.008333333333333333};
    private final double[] coeffTaylorE2 = new double[]{1.0, 0.6666666666666666, 0.25, 0.06666666666666667, 0.013888888888888888};
    private final double[] coeffTaylorE3 = new double[]{1.0, 0.75, 0.3, 0.08333333333333333, 0.017857142857142856};
    private final double[] coeffTaylorE17 = new double[]{1.0, 0.5, 0.16666666666666666, 0.041666666666666664, 0.008333333333333333, 0.001388888888888889, 1.984126984126984E-4};
    private final double[] coeffTaylorE27 = new double[]{1.0, 0.6666666666666666, 0.25, 0.06666666666666667, 0.013888888888888888, 0.002380952380952381, 3.4722222222222224E-4};
    private final double[] coeffTaylorE37 = new double[]{1.0, 0.75, 0.3, 0.08333333333333333, 0.017857142857142856, 0.003125, 4.62962962962963E-4};
    private RandomVariableFactory abstractRandomVariableFactory;
    private final RandomVariable a;
    private final RandomVariable b;
    private final RandomVariable c;
    private final RandomVariable d;
    private boolean isCalibrateable = false;

    public LIBORVolatilityModelFourParameterExponentialFormIntegrated(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.a = abstractRandomVariableFactory.createRandomVariable(a);
        this.b = abstractRandomVariableFactory.createRandomVariable(b);
        this.c = abstractRandomVariableFactory.createRandomVariable(c);
        this.d = abstractRandomVariableFactory.createRandomVariable(d);
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFourParameterExponentialFormIntegrated(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable a, RandomVariable b, RandomVariable c, RandomVariable d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFourParameterExponentialFormIntegrated(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = new Scalar(a);
        this.b = new Scalar(b);
        this.c = new Scalar(c);
        this.d = new Scalar(d);
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public LIBORVolatilityModelFourParameterExponentialFormIntegrated getCloneWithModifiedParameter(RandomVariable[] parameter) {
        if (!this.isCalibrateable) {
            return this;
        }
        return new LIBORVolatilityModelFourParameterExponentialFormIntegrated(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), parameter[0], parameter[1], parameter[2], parameter[3], this.isCalibrateable);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        double timeStart = this.getTimeDiscretization().getTime(timeIndex);
        double timeEnd = this.getTimeDiscretization().getTime(timeIndex + 1);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        if (maturity - timeStart <= 0.0) {
            return new Scalar(0.0);
        }
        RandomVariable varianceInstantaneous = this.getIntegratedVariance(maturity - timeStart).sub(this.getIntegratedVariance(maturity - timeEnd)).div(timeEnd - timeStart);
        return varianceInstantaneous.sqrt();
    }

    private RandomVariable getIntegratedVariance(double maturity) {
        RandomVariable cCutOff2;
        if (maturity == 0.0) {
            return new Scalar(0.0);
        }
        RandomVariable aaT = this.a.squared().mult(maturity);
        RandomVariable abTT = this.a.mult(this.b).mult(maturity * maturity);
        RandomVariable ad2T = this.a.mult(this.d).mult(2.0 * maturity);
        RandomVariable bbTTT = this.b.squared().mult(maturity * maturity * maturity / 3.0);
        RandomVariable bdTT = this.b.mult(this.d).mult(maturity * maturity);
        RandomVariable ddT = this.d.squared().mult(maturity);
        RandomVariable mcT = this.c.mult(-maturity);
        RandomVariable mcT2 = mcT.mult(2.0);
        RandomVariable expA1 = mcT.expm1().div(mcT);
        RandomVariable expA2 = mcT.sub(expA1.log()).expm1().div(mcT).mult(expA1).mult(2.0);
        RandomVariable expB1 = mcT2.expm1().div(mcT2);
        RandomVariable expB2 = mcT2.sub(expB1.log()).expm1().div(mcT2).mult(expB1).mult(2.0);
        RandomVariable expB3 = mcT2.sub(expB2.log()).expm1().div(mcT2).mult(expB2).mult(3.0);
        RandomVariable pA1 = this.polynom(mcT, this.coeffTaylorE1);
        RandomVariable pA2 = this.polynom(mcT, this.coeffTaylorE2);
        RandomVariable pB1 = this.polynom(mcT2, this.coeffTaylorE1);
        RandomVariable pB2 = this.polynom(mcT2, this.coeffTaylorE2);
        RandomVariable pB3 = this.polynom(mcT2, this.coeffTaylorE3);
        RandomVariable cCutOff1 = mcT.abs().sub(1.0E-12).choose(new Scalar(1.0), new Scalar(-1.0));
        RandomVariable cCutOff3 = cCutOff2 = mcT.abs().sub(0.01).choose(new Scalar(1.0), new Scalar(-1.0));
        expA1 = cCutOff1.choose(expA1, pA1);
        expA2 = cCutOff2.choose(expA2, pA2);
        expB1 = cCutOff1.choose(expB1, pB1);
        expB2 = cCutOff2.choose(expB2, pB2);
        expB3 = cCutOff3.choose(expB3, pB3);
        RandomVariable integratedVariance = aaT.mult(expB1);
        integratedVariance = integratedVariance.add(abTT.mult(expB2));
        integratedVariance = integratedVariance.add(ad2T.mult(expA1));
        integratedVariance = integratedVariance.add(bbTTT.mult(expB3));
        integratedVariance = integratedVariance.add(bdTT.mult(expA2));
        integratedVariance = integratedVariance.add(ddT);
        return integratedVariance;
    }

    private RandomVariable polynom(RandomVariable x, double[] coeff) {
        RandomVariable p = x.mult(coeff[coeff.length - 1]).add(coeff[coeff.length - 2]);
        for (int i = coeff.length - 3; i >= 0; --i) {
            p = p.mult(x).add(coeff[i]);
        }
        return p;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialFormIntegrated(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory abstractRandomVariableFactory = null;
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        RandomVariable a = this.a;
        RandomVariable b = this.b;
        RandomVariable c = this.c;
        RandomVariable d = this.d;
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            abstractRandomVariableFactory = dataModified.getOrDefault("randomVariableFactory", abstractRandomVariableFactory);
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            if (dataModified.containsKey("randomVariableFactory")) {
                a = abstractRandomVariableFactory.createRandomVariable(a.doubleValue());
                b = abstractRandomVariableFactory.createRandomVariable(b.doubleValue());
                c = abstractRandomVariableFactory.createRandomVariable(c.doubleValue());
                d = abstractRandomVariableFactory.createRandomVariable(d.doubleValue());
            }
            a = dataModified.getOrDefault("a", a) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("a", a) : (abstractRandomVariableFactory != null ? abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("a")) : new Scalar((Double)dataModified.get("a")));
            b = dataModified.getOrDefault("b", b) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("b", b)).doubleValue()) : (abstractRandomVariableFactory != null ? abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("b")) : new Scalar((Double)dataModified.get("b")));
            c = dataModified.getOrDefault("c", c) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("c", c)).doubleValue()) : (abstractRandomVariableFactory != null ? abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("c")) : new Scalar((Double)dataModified.get("c")));
            d = dataModified.getOrDefault("d", d) instanceof RandomVariable ? abstractRandomVariableFactory.createRandomVariable(((RandomVariable)dataModified.getOrDefault("d", d)).doubleValue()) : (abstractRandomVariableFactory != null ? abstractRandomVariableFactory.createRandomVariable((Double)dataModified.get("d")) : new Scalar((Double)dataModified.get("d")));
        }
        LIBORVolatilityModelFourParameterExponentialFormIntegrated newModel = new LIBORVolatilityModelFourParameterExponentialFormIntegrated(timeDiscretization, liborPeriodDiscretization, a, b, c, d, isCalibrateable);
        return newModel;
    }
}

