/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelFromGivenMatrix
extends LIBORVolatilityModel {
    private static final long serialVersionUID = -8017326082950665302L;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final RandomVariable[][] volatility;
    private final boolean isCalibrateable;
    private transient RandomVariable[] parameter;

    public LIBORVolatilityModelFromGivenMatrix(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable[][] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.volatility = (RandomVariable[][])volatility.clone();
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFromGivenMatrix(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable[][] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = new RandomVariableFromArrayFactory();
        this.volatility = (RandomVariable[][])volatility.clone();
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFromGivenMatrix(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable[][] volatility) {
        this(timeDiscretization, liborPeriodDiscretization, volatility, false);
    }

    public LIBORVolatilityModelFromGivenMatrix(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double[][] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.volatility = abstractRandomVariableFactory.createRandomVariableMatrix(volatility);
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFromGivenMatrix(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double[][] volatility) {
        this(abstractRandomVariableFactory, timeDiscretization, liborPeriodDiscretization, volatility, true);
    }

    public LIBORVolatilityModelFromGivenMatrix(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double[][] volatility) {
        this(new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, volatility);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int component) {
        return this.volatility[timeIndex][component];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable[] getParameter() {
        RandomVariable[][] randomVariableArray = this.volatility;
        synchronized (this.volatility) {
            if (this.parameter == null) {
                ArrayList<RandomVariable> parameterArray = new ArrayList<RandomVariable>();
                for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
                    for (int liborPeriodIndex = 0; liborPeriodIndex < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++liborPeriodIndex) {
                        if (!(this.getTimeDiscretization().getTime(timeIndex) < this.getLiborPeriodDiscretization().getTime(liborPeriodIndex))) continue;
                        parameterArray.add(this.getVolatility(timeIndex, liborPeriodIndex));
                    }
                }
                this.parameter = parameterArray.toArray(new RandomVariable[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.parameter;
        }
    }

    @Override
    public LIBORVolatilityModelFromGivenMatrix getCloneWithModifiedParameter(RandomVariable[] parameter) {
        RandomVariable[][] newVoltility = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
        int parameterIndex = 0;
        for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
            for (int liborPeriodIndex = 0; liborPeriodIndex < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++liborPeriodIndex) {
                if (!(this.getTimeDiscretization().getTime(timeIndex) < this.getLiborPeriodDiscretization().getTime(liborPeriodIndex))) continue;
                newVoltility[timeIndex][liborPeriodIndex] = parameter[parameterIndex++];
            }
        }
        return new LIBORVolatilityModelFromGivenMatrix(this.abstractRandomVariableFactory, this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), newVoltility, this.isCalibrateable);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFromGivenMatrix(this.abstractRandomVariableFactory, this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), (RandomVariable[][])this.volatility.clone(), this.isCalibrateable);
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory abstractRandomVariableFactory = null;
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        RandomVariable[][] volatility = this.volatility;
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            abstractRandomVariableFactory = dataModified.getOrDefault("randomVariableFactory", abstractRandomVariableFactory);
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            if (dataModified.containsKey("randomVariableFactory")) {
                for (int i = 0; i < volatility.length; ++i) {
                    for (int j = 0; j < volatility[i].length; ++j) {
                        volatility[i][j] = abstractRandomVariableFactory.createRandomVariable(volatility[i][j].doubleValue());
                    }
                }
            }
        }
        LIBORVolatilityModelFromGivenMatrix newModel = new LIBORVolatilityModelFromGivenMatrix(abstractRandomVariableFactory, timeDiscretization, liborPeriodDiscretization, volatility, isCalibrateable);
        return newModel;
    }
}

