/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelPiecewiseConstant
extends LIBORVolatilityModel {
    private static final long serialVersionUID = 3258093488453501312L;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final TimeDiscretization simulationTimeDiscretization;
    private final TimeDiscretization timeToMaturityDiscretization;
    private final Map<Integer, Map<Integer, Integer>> indexMap = new ConcurrentHashMap<Integer, Map<Integer, Integer>>();
    private RandomVariable[] volatility;
    private final boolean isCalibrateable;

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, RandomVariable[] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = new RandomVariableFromArrayFactory();
        double maxMaturity = liborPeriodDiscretization.getTime(liborPeriodDiscretization.getNumberOfTimes() - 1);
        int volatilityIndex = 0;
        for (int simulationTime = 0; simulationTime < simulationTimeDiscretization.getNumberOfTimes(); ++simulationTime) {
            HashMap<Integer, Integer> timeToMaturityIndexing = new HashMap<Integer, Integer>();
            for (int timeToMaturity = 0; timeToMaturity < timeToMaturityDiscretization.getNumberOfTimes(); ++timeToMaturity) {
                if (simulationTimeDiscretization.getTime(simulationTime) + timeToMaturityDiscretization.getTime(timeToMaturity) > maxMaturity) continue;
                timeToMaturityIndexing.put(timeToMaturity, volatilityIndex++);
            }
            this.indexMap.put(simulationTime, timeToMaturityIndexing);
        }
        if (volatility.length == 1) {
            this.volatility = new RandomVariable[volatilityIndex];
            Arrays.fill(this.volatility, volatility[0]);
        } else if (volatility.length == volatilityIndex) {
            this.volatility = (RandomVariable[])volatility.clone();
        } else {
            throw new IllegalArgumentException("Volatility length does not match number of free parameters.");
        }
        if (volatilityIndex != this.volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal simulationTimeDiscretization.getNumberOfTimes()*timeToMaturityDiscretization.getNumberOfTimes().");
        }
        this.simulationTimeDiscretization = simulationTimeDiscretization;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelPiecewiseConstant(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double[][] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        double maxMaturity = liborPeriodDiscretization.getTime(liborPeriodDiscretization.getNumberOfTimes() - 1);
        int volatilityIndex = 0;
        for (int simulationTime = 0; simulationTime < simulationTimeDiscretization.getNumberOfTimes(); ++simulationTime) {
            ConcurrentHashMap<Integer, Integer> timeToMaturityIndexing = new ConcurrentHashMap<Integer, Integer>();
            for (int timeToMaturity = 0; timeToMaturity < timeToMaturityDiscretization.getNumberOfTimes(); ++timeToMaturity) {
                if (simulationTimeDiscretization.getTime(simulationTime) + timeToMaturityDiscretization.getTime(timeToMaturity) > maxMaturity) continue;
                timeToMaturityIndexing.put(timeToMaturity, volatilityIndex++);
            }
            this.indexMap.put(simulationTime, timeToMaturityIndexing);
        }
        this.volatility = new RandomVariable[volatilityIndex];
        for (Integer simulationTime : this.indexMap.keySet()) {
            for (Integer timeToMaturity : this.indexMap.get(simulationTime).keySet()) {
                this.volatility[this.indexMap.get((Object)simulationTime).get((Object)timeToMaturity).intValue()] = abstractRandomVariableFactory.createRandomVariable(volatility[simulationTime][timeToMaturity]);
            }
        }
        this.simulationTimeDiscretization = simulationTimeDiscretization;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelPiecewiseConstant(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double[] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        double maxMaturity = liborPeriodDiscretization.getTime(liborPeriodDiscretization.getNumberOfTimes() - 1);
        int volatilityIndex = 0;
        for (int simulationTime = 0; simulationTime < simulationTimeDiscretization.getNumberOfTimes(); ++simulationTime) {
            HashMap<Integer, Integer> timeToMaturityIndexing = new HashMap<Integer, Integer>();
            for (int timeToMaturity = 0; timeToMaturity < timeToMaturityDiscretization.getNumberOfTimes(); ++timeToMaturity) {
                if (simulationTimeDiscretization.getTime(simulationTime) + timeToMaturityDiscretization.getTime(timeToMaturity) > maxMaturity) continue;
                timeToMaturityIndexing.put(timeToMaturity, volatilityIndex++);
            }
            this.indexMap.put(simulationTime, timeToMaturityIndexing);
        }
        if (volatility.length == 1) {
            this.volatility = new RandomVariable[volatilityIndex];
            Arrays.fill(this.volatility, abstractRandomVariableFactory.createRandomVariable(volatility[0]));
        } else if (volatility.length == volatilityIndex) {
            this.volatility = new RandomVariable[volatilityIndex];
            for (int i = 0; i < volatility.length; ++i) {
                this.volatility[i] = abstractRandomVariableFactory.createRandomVariable(volatility[i]);
            }
        } else {
            throw new IllegalArgumentException("Volatility length does not match number of free parameters.");
        }
        if (volatilityIndex != this.volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal simulationTimeDiscretization.getNumberOfTimes()*timeToMaturityDiscretization.getNumberOfTimes().");
        }
        this.simulationTimeDiscretization = simulationTimeDiscretization;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double[] volatility, boolean isCalibrateable) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, volatility, isCalibrateable);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double volatility, boolean isCalibrateable) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, new double[]{volatility}, isCalibrateable);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double[] volatility) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, volatility, true);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization simulationTimeDiscretization, TimeDiscretization timeToMaturityDiscretization, double volatility) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, new double[]{volatility});
    }

    @Override
    public RandomVariable[] getParameter() {
        if (this.isCalibrateable) {
            return this.volatility;
        }
        return null;
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedParameter(RandomVariable[] parameter) {
        return new LIBORVolatilityModelPiecewiseConstant(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.simulationTimeDiscretization, this.timeToMaturityDiscretization, parameter, this.isCalibrateable);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        int timeIndexTimeToMaturity;
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        if (timeToMaturity <= 0.0) {
            double volatilityInstanteaneous = 0.0;
            return this.abstractRandomVariableFactory == null ? new Scalar(0.0) : this.abstractRandomVariableFactory.createRandomVariable(time, volatilityInstanteaneous);
        }
        int timeIndexSimulationTime = this.simulationTimeDiscretization.getTimeIndexNearestLessOrEqual(time);
        if (timeIndexSimulationTime < 0) {
            timeIndexSimulationTime = 0;
        }
        if (timeIndexSimulationTime >= this.simulationTimeDiscretization.getNumberOfTimes()) {
            --timeIndexSimulationTime;
        }
        if ((timeIndexTimeToMaturity = this.timeToMaturityDiscretization.getTimeIndexNearestLessOrEqual(timeToMaturity)) < 0) {
            timeIndexTimeToMaturity = 0;
        }
        if (timeIndexTimeToMaturity >= this.timeToMaturityDiscretization.getNumberOfTimes()) {
            --timeIndexTimeToMaturity;
        }
        int parameterIndex = this.indexMap.get(timeIndexSimulationTime).get(timeIndexTimeToMaturity);
        return this.volatility[parameterIndex];
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelPiecewiseConstant(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.simulationTimeDiscretization, this.timeToMaturityDiscretization, (RandomVariable[])this.volatility.clone(), this.isCalibrateable);
    }

    public TimeDiscretization getSimulationTimeDiscretization() {
        return this.simulationTimeDiscretization;
    }

    public TimeDiscretization getTimeToMaturityDiscretization() {
        return this.timeToMaturityDiscretization;
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory abstractRandomVariableFactory = this.abstractRandomVariableFactory;
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        TimeDiscretization simulationTimeDiscretization = this.getSimulationTimeDiscretization();
        TimeDiscretization timeToMaturityDiscretization = this.getTimeToMaturityDiscretization();
        double[][] volatility = new double[simulationTimeDiscretization.getNumberOfTimes()][timeToMaturityDiscretization.getNumberOfTimes()];
        for (int i = 0; i < volatility.length; ++i) {
            for (int j = 0; j < volatility[i].length; ++j) {
                volatility[i][j] = this.volatility[this.indexMap.get(i).get(j)].doubleValue();
            }
        }
        if (dataModified != null) {
            abstractRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", abstractRandomVariableFactory);
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            simulationTimeDiscretization = (TimeDiscretization)dataModified.getOrDefault("simulationTimeDiscretization", simulationTimeDiscretization);
            timeToMaturityDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeToMaturityDiscretization", timeToMaturityDiscretization);
            if (dataModified.getOrDefault("volatility", volatility) instanceof double[][]) {
                volatility = (double[][])dataModified.getOrDefault("volatility", volatility);
            } else {
                throw new UnsupportedOperationException("volatility parameter type not supported.");
            }
        }
        LIBORVolatilityModelPiecewiseConstant newModel = new LIBORVolatilityModelPiecewiseConstant(abstractRandomVariableFactory, timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, volatility, this.isCalibrateable);
        return newModel;
    }
}

