/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelTwoParameterExponentialForm
extends LIBORVolatilityModel {
    private static final long serialVersionUID = 8398006103722351360L;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final RandomVariable a;
    private final RandomVariable b;
    private boolean isCalibrateable = false;
    private transient RandomVariable[][] volatility;
    private final Object volatilityLazyInitLock = new Object();

    public LIBORVolatilityModelTwoParameterExponentialForm(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable a, RandomVariable b, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.a = a;
        this.b = b;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelTwoParameterExponentialForm(RandomVariableFactory abstractRandomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, boolean isCalibrateable) {
        this(abstractRandomVariableFactory, timeDiscretization, liborPeriodDiscretization, abstractRandomVariableFactory.createRandomVariable(a), abstractRandomVariableFactory.createRandomVariable(b), isCalibrateable);
    }

    public LIBORVolatilityModelTwoParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, a, b, true);
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[]{this.a, this.b};
        return parameter;
    }

    @Override
    public LIBORVolatilityModelTwoParameterExponentialForm getCloneWithModifiedParameter(RandomVariable[] parameter) {
        if (!this.isCalibrateable) {
            return this;
        }
        return new LIBORVolatilityModelTwoParameterExponentialForm(this.abstractRandomVariableFactory, this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameter[0], parameter[1], this.isCalibrateable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        Object object = this.volatilityLazyInitLock;
        synchronized (object) {
            if (this.volatility == null) {
                this.volatility = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
            }
            if (this.volatility[timeIndex][liborIndex] == null) {
                double time = this.getTimeDiscretization().getTime(timeIndex);
                double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
                double timeToMaturity = maturity - time;
                RandomVariable volatilityInstanteaneous = timeToMaturity <= 0.0 ? this.abstractRandomVariableFactory.createRandomVariable(0.0) : this.a.mult(this.b.mult(-timeToMaturity).exp());
                this.volatility[timeIndex][liborIndex] = volatilityInstanteaneous;
            }
            return this.volatility[timeIndex][liborIndex];
        }
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelTwoParameterExponentialForm(this.abstractRandomVariableFactory, this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.a, this.b, this.isCalibrateable);
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        return null;
    }
}

