/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.ToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.finmath.exception.CalculationException;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationLinearRegressionFactory;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegressionFactory;
import net.finmath.montecarlo.conditionalexpectation.RegressionBasisFunctionsProvider;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionFromSwapSchedules;
import net.finmath.montecarlo.process.ProcessTimeDiscretizationProvider;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class BermudanSwaptionFromSwapSchedules
extends AbstractLIBORMonteCarloProduct
implements RegressionBasisFunctionsProvider,
ProcessTimeDiscretizationProvider,
Swaption {
    private static Logger logger = Logger.getLogger("net.finmath");
    private final LocalDateTime referenceDate;
    private final SwaptionType swaptionType;
    private final LocalDate[] exerciseDates;
    private final LocalDate swapEndDate;
    private final double[] swaprates;
    private final double[] notionals;
    private final Schedule[] fixSchedules;
    private final Schedule[] floatSchedules;
    private final RegressionBasisFunctionsProvider regressionBasisFunctionProvider;
    private final MonteCarloConditionalExpectationRegressionFactory conditionalExpectationRegressionFactory;
    private final boolean isUseAnalyticSwapValuationAtExercise = true;

    public BermudanSwaptionFromSwapSchedules(LocalDateTime referenceDate, SwaptionType swaptionType, LocalDate[] exerciseDates, LocalDate swapEndDate, double[] swaprates, double[] notionals, Schedule[] fixSchedules, Schedule[] floatSchedules, MonteCarloConditionalExpectationRegressionFactory conditionalExpectationRegressionFactory, RegressionBasisFunctionsProvider regressionBasisFunctionProvider) {
        this.referenceDate = referenceDate;
        this.swaptionType = swaptionType;
        this.swapEndDate = swapEndDate;
        this.swaprates = swaprates;
        this.notionals = notionals;
        this.exerciseDates = exerciseDates;
        this.fixSchedules = fixSchedules;
        this.floatSchedules = floatSchedules;
        this.regressionBasisFunctionProvider = regressionBasisFunctionProvider != null ? regressionBasisFunctionProvider : this;
        this.conditionalExpectationRegressionFactory = conditionalExpectationRegressionFactory;
    }

    public BermudanSwaptionFromSwapSchedules(LocalDateTime referenceDate, SwaptionType swaptionType, LocalDate[] exerciseDates, LocalDate swapEndDate, double[] swaprates, double[] notionals, Schedule[] fixSchedules, Schedule[] floatSchedules, RegressionBasisFunctionsProvider regressionBasisFunctionProvider) {
        this(referenceDate, swaptionType, exerciseDates, swapEndDate, swaprates, notionals, fixSchedules, floatSchedules, new MonteCarloConditionalExpectationLinearRegressionFactory(), regressionBasisFunctionProvider);
    }

    public BermudanSwaptionFromSwapSchedules(LocalDateTime referenceDate, SwaptionType swaptionType, LocalDate[] exerciseDates, LocalDate swapEndDate, double[] swaprates, double[] notionals, Schedule[] fixSchedules, Schedule[] floatSchedules) {
        this(referenceDate, swaptionType, exerciseDates, swapEndDate, swaprates, notionals, fixSchedules, floatSchedules, null);
    }

    public BermudanSwaptionFromSwapSchedules(LocalDateTime referenceDate, SwaptionType swaptionType, LocalDate[] exerciseDates, LocalDate swapEndDate, final double swaprate, final double notional, Schedule[] fixSchedules, Schedule[] floatSchedules) {
        this(referenceDate, swaptionType, exerciseDates, swapEndDate, IntStream.range(0, exerciseDates.length).mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return swaprate;
            }
        }).toArray(), IntStream.range(0, exerciseDates.length).mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return notional;
            }
        }).toArray(), fixSchedules, floatSchedules);
    }

    public LocalDate[] getExerciseDates() {
        return this.exerciseDates;
    }

    public SwaptionType getSwaptionType() {
        return this.swaptionType;
    }

    public LocalDate getSwapEndDate() {
        return this.swapEndDate;
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        LocalDate modelReferenceDate = model.getReferenceDate().toLocalDate();
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseTimes = new Scalar(Double.POSITIVE_INFINITY);
        RandomVariable valuesUnderlying = model.getRandomVariableForConstant(0.0);
        for (int exerciseIndex = this.exerciseDates.length - 1; exerciseIndex >= 0; --exerciseIndex) {
            RandomVariable discountedPayoff;
            double exerciseTime = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, this.exerciseDates[exerciseIndex]);
            RandomVariable discountedCashflowFixLeg = this.getValueUnderlyingNumeraireRelative(model, this.fixSchedules[exerciseIndex], false, this.swaprates[exerciseIndex], this.notionals[exerciseIndex]);
            RandomVariable discountedCashflowFloatingLeg = this.getValueUnderlyingNumeraireRelative(model, this.floatSchedules[exerciseIndex], true, 0.0, this.notionals[exerciseIndex]);
            if (this.swaptionType.equals((Object)SwaptionType.PAYER)) {
                valuesUnderlying = discountedPayoff = discountedCashflowFloatingLeg.sub(discountedCashflowFixLeg);
            } else if (this.swaptionType.equals((Object)SwaptionType.RECEIVER)) {
                valuesUnderlying = discountedPayoff = discountedCashflowFixLeg.sub(discountedCashflowFloatingLeg);
            }
            RandomVariable discountedTriggerValues = values.sub(valuesUnderlying);
            ConditionalExpectationEstimator conditionalExpectationOperator = this.getConditionalExpectationEstimator(exerciseTime, model);
            RandomVariable triggerValues = discountedTriggerValues.getConditionalExpectation(conditionalExpectationOperator);
            values = triggerValues.choose(values, valuesUnderlying);
            exerciseTimes = triggerValues.choose(exerciseTimes, new Scalar(exerciseTime));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Exercise probabilitie " + this.getExerciseProbabilitiesFromTimes(model.getReferenceDate(), exerciseTimes));
            double probabilityToExercise = 1.0;
            for (int exerciseIndex = 0; exerciseIndex < this.exerciseDates.length; ++exerciseIndex) {
                double exerciseTime = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, this.exerciseDates[exerciseIndex]);
                double probabilityToExerciseAfter = exerciseTimes.sub(exerciseTime + 0.0027397260273972603).choose(new Scalar(1.0), new Scalar(0.0)).getAverage();
                double probability = probabilityToExercise - probabilityToExerciseAfter;
                probabilityToExercise = probabilityToExerciseAfter;
                logger.finer("Exercise " + (exerciseIndex + 1) + " on " + this.exerciseDates[exerciseIndex] + " with probability " + probability);
            }
            logger.finer("No exercise with probability " + probabilityToExercise);
        }
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("values", values);
        results.put("exerciseTimes", exerciseTimes);
        return results;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        return (RandomVariable)this.getValues(evaluationTime, model).get("values");
    }

    public double[] getExerciseProbabilitiesFromTimes(LocalDateTime localDateTime, RandomVariable exerciseTimes) {
        double[] exerciseProbabilities = new double[this.exerciseDates.length + 1];
        double probabilityToExercise = 1.0;
        for (int exerciseIndex = 0; exerciseIndex < this.exerciseDates.length; ++exerciseIndex) {
            double exerciseTime = FloatingpointDate.getFloatingPointDateFromDate(localDateTime, this.exerciseDates[exerciseIndex].atStartOfDay());
            double probabilityToExerciseAfter = exerciseTimes.sub(exerciseTime + 0.0027397260273972603).choose(new Scalar(1.0), new Scalar(0.0)).getAverage();
            exerciseProbabilities[exerciseIndex] = probabilityToExercise - probabilityToExerciseAfter;
            probabilityToExercise = probabilityToExerciseAfter;
        }
        exerciseProbabilities[this.exerciseDates.length] = probabilityToExercise;
        return exerciseProbabilities;
    }

    @Override
    public TimeDiscretization getProcessTimeDiscretization(final LocalDateTime referenceDate) {
        HashSet<Double> times = new HashSet<Double>();
        for (int exerciseDateIndex = 0; exerciseDateIndex < this.exerciseDates.length; ++exerciseDateIndex) {
            times.add(FloatingpointDate.getFloatingPointDateFromDate(referenceDate, this.exerciseDates[exerciseDateIndex].atStartOfDay()));
            Schedule scheduleFixedLeg = this.fixSchedules[exerciseDateIndex];
            Schedule scheduleFloatLeg = this.floatSchedules[exerciseDateIndex];
            Function<Period, Double> periodToTime = new Function<Period, Double>(){

                @Override
                public Double apply(Period period) {
                    return FloatingpointDate.getFloatingPointDateFromDate(referenceDate, period.getPayment().atStartOfDay());
                }
            };
            times.addAll(scheduleFixedLeg.getPeriods().stream().map(periodToTime).collect(Collectors.toList()));
            times.addAll(scheduleFloatLeg.getPeriods().stream().map(periodToTime).collect(Collectors.toList()));
        }
        return new TimeDiscretizationFromArray(times);
    }

    private RandomVariable getValueUnderlyingNumeraireRelative(LIBORModelMonteCarloSimulationModel model, Schedule legSchedule, boolean paysFloat, double swaprate, double notional) throws CalculationException {
        double valuationTime = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate().toLocalDate(), legSchedule.getPeriod(0).getFixing());
        RandomVariable numeraireAtValuationTime = model.getNumeraire(valuationTime);
        RandomVariable monteCarloProbabilitiesAtValuationTime = model.getMonteCarloWeights(valuationTime);
        RandomVariable value = SwaptionFromSwapSchedules.getValueOfLegAnalytic(valuationTime, model, legSchedule, paysFloat, swaprate, notional);
        value = value.div(model.getNumeraire(valuationTime)).mult(monteCarloProbabilitiesAtValuationTime);
        return value;
    }

    public ConditionalExpectationEstimator getConditionalExpectationEstimator(double exerciseTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable[] regressionBasisFunctions = this.regressionBasisFunctionProvider.getBasisFunctions(exerciseTime, model);
        return this.conditionalExpectationRegressionFactory.getConditionalExpectationEstimator(regressionBasisFunctions, regressionBasisFunctions);
    }

    @Override
    public RandomVariable[] getBasisFunctions(double evaluationTime, MonteCarloSimulationModel model) throws CalculationException {
        LIBORModelMonteCarloSimulationModel liborModel = (LIBORModelMonteCarloSimulationModel)model;
        return this.getBasisFunctions(evaluationTime, liborModel);
    }

    public RandomVariable[] getBasisFunctions(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        final LocalDateTime modelReferenceDate = model.getReferenceDate();
        double[] regressionBasisfunctionTimes = Stream.concat(Arrays.stream(this.exerciseDates), Stream.of(this.swapEndDate)).mapToDouble(new ToDoubleFunction<LocalDate>(){

            @Override
            public double applyAsDouble(LocalDate date) {
                return FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, date.atStartOfDay());
            }
        }).sorted().toArray();
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        double exerciseTime = evaluationTime;
        int exerciseIndex = Arrays.binarySearch(regressionBasisfunctionTimes, exerciseTime);
        if (exerciseIndex < 0) {
            exerciseIndex = -exerciseIndex;
        }
        if (exerciseIndex >= this.exerciseDates.length) {
            exerciseIndex = this.exerciseDates.length - 1;
        }
        RandomVariableFromDoubleArray one = new RandomVariableFromDoubleArray(1.0);
        basisFunctions.add(one);
        RandomVariable discountFactor = model.getNumeraire(exerciseTime).invert();
        basisFunctions.add(discountFactor);
        for (int exerciseIndexUnderlying = exerciseIndex; exerciseIndexUnderlying < this.exerciseDates.length; ++exerciseIndexUnderlying) {
            RandomVariable floatLeg = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, this.floatSchedules[exerciseIndexUnderlying], true, 0.0, 1.0);
            RandomVariable annuity = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, this.fixSchedules[exerciseIndexUnderlying], false, 1.0, 1.0);
            RandomVariable swapRate = floatLeg.div(annuity);
            RandomVariable basisFunction = swapRate.mult(discountFactor);
            basisFunctions.add(basisFunction);
            basisFunctions.add(basisFunction.squared());
        }
        RandomVariable rateShort = model.getLIBOR(exerciseTime, exerciseTime, regressionBasisfunctionTimes[exerciseIndex + 1]);
        basisFunctions.add(rateShort.mult(discountFactor));
        basisFunctions.add(rateShort.mult(discountFactor).pow(2.0));
        return basisFunctions.toArray(new RandomVariable[basisFunctions.size()]);
    }

    public RegressionBasisFunctionsProvider getBasisFunctionsProviderWithSwapRates() {
        return new RegressionBasisFunctionsProvider(){

            @Override
            public RandomVariable[] getBasisFunctions(double evaluationTime, MonteCarloSimulationModel monteCarloModel) throws CalculationException {
                RandomVariableFromDoubleArray one;
                LIBORModelMonteCarloSimulationModel model = (LIBORModelMonteCarloSimulationModel)monteCarloModel;
                final LocalDateTime modelReferenceDate = model.getReferenceDate();
                double[] regressionBasisfunctionTimes = Stream.concat(Arrays.stream(BermudanSwaptionFromSwapSchedules.this.exerciseDates), Stream.of(BermudanSwaptionFromSwapSchedules.this.swapEndDate)).mapToDouble(new ToDoubleFunction<LocalDate>(){

                    @Override
                    public double applyAsDouble(LocalDate date) {
                        return FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, date.atStartOfDay());
                    }
                }).sorted().toArray();
                ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
                double exerciseTime = evaluationTime;
                int exerciseIndex = Arrays.binarySearch(regressionBasisfunctionTimes, exerciseTime);
                if (exerciseIndex < 0) {
                    exerciseIndex = -exerciseIndex;
                }
                if (exerciseIndex >= BermudanSwaptionFromSwapSchedules.this.exerciseDates.length) {
                    exerciseIndex = BermudanSwaptionFromSwapSchedules.this.exerciseDates.length - 1;
                }
                RandomVariableFromDoubleArray basisFunction = one = new RandomVariableFromDoubleArray(1.0);
                basisFunctions.add(basisFunction);
                for (int exerciseIndexUnderlying = exerciseIndex; exerciseIndexUnderlying < BermudanSwaptionFromSwapSchedules.this.exerciseDates.length; ++exerciseIndexUnderlying) {
                    RandomVariable floatLeg = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, BermudanSwaptionFromSwapSchedules.this.floatSchedules[exerciseIndexUnderlying], true, 0.0, 1.0);
                    RandomVariable annuity = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, BermudanSwaptionFromSwapSchedules.this.fixSchedules[exerciseIndexUnderlying], false, 1.0, 1.0);
                    RandomVariable swapRate = floatLeg.div(annuity);
                    basisFunctions.add(swapRate);
                }
                RandomVariable rateShort = model.getLIBOR(exerciseTime, exerciseTime, regressionBasisfunctionTimes[exerciseIndex + 1]);
                basisFunctions.add(rateShort);
                basisFunctions.add(rateShort.pow(2.0));
                RandomVariable discountFactor = model.getNumeraire(exerciseTime).invert();
                basisFunctions.add(discountFactor);
                return basisFunctions.toArray(new RandomVariable[basisFunctions.size()]);
            }
        };
    }

    public RegressionBasisFunctionsProvider getBasisFunctionsProviderWithForwardRates() {
        return new RegressionBasisFunctionsProvider(){

            @Override
            public RandomVariable[] getBasisFunctions(double evaluationTime, MonteCarloSimulationModel monteCarloModel) throws CalculationException {
                RandomVariableFromDoubleArray one;
                LIBORModelMonteCarloSimulationModel model = (LIBORModelMonteCarloSimulationModel)monteCarloModel;
                final LocalDateTime modelReferenceDate = model.getReferenceDate();
                double[] regressionBasisfunctionTimes = Stream.concat(Arrays.stream(BermudanSwaptionFromSwapSchedules.this.exerciseDates), Stream.of(BermudanSwaptionFromSwapSchedules.this.swapEndDate)).mapToDouble(new ToDoubleFunction<LocalDate>(){

                    @Override
                    public double applyAsDouble(LocalDate date) {
                        return FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, date.atStartOfDay());
                    }
                }).sorted().toArray();
                ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
                double swapMaturity = FloatingpointDate.getFloatingPointDateFromDate(BermudanSwaptionFromSwapSchedules.this.referenceDate, BermudanSwaptionFromSwapSchedules.this.swapEndDate.atStartOfDay());
                double exerciseTime = evaluationTime;
                int exerciseIndex = Arrays.binarySearch(regressionBasisfunctionTimes, exerciseTime);
                if (exerciseIndex < 0) {
                    exerciseIndex = -exerciseIndex;
                }
                if (exerciseIndex >= BermudanSwaptionFromSwapSchedules.this.exerciseDates.length) {
                    exerciseIndex = BermudanSwaptionFromSwapSchedules.this.exerciseDates.length - 1;
                }
                RandomVariableFromDoubleArray basisFunction = one = new RandomVariableFromDoubleArray(1.0);
                basisFunctions.add(basisFunction);
                RandomVariable rateShort = model.getLIBOR(exerciseTime, exerciseTime, regressionBasisfunctionTimes[exerciseIndex + 1]);
                basisFunctions.add(rateShort);
                basisFunctions.add(rateShort.pow(2.0));
                RandomVariable rateLong = model.getLIBOR(exerciseTime, regressionBasisfunctionTimes[exerciseIndex], swapMaturity);
                basisFunctions.add(rateLong);
                basisFunctions.add(rateLong.pow(2.0));
                RandomVariable discountFactor = model.getNumeraire(exerciseTime).invert();
                basisFunctions.add(discountFactor);
                basisFunctions.add(rateLong.mult(discountFactor));
                return basisFunctions.toArray(new RandomVariable[basisFunctions.size()]);
            }
        };
    }

    @Override
    public String toString() {
        return "BermudanSwaptionFromSwapSchedules[type: " + this.swaptionType.toString() + ", exerciseDate: " + Arrays.toString(this.exerciseDates) + ", swapEndDate: " + this.swapEndDate + ", strike: " + Arrays.toString(this.swaprates) + ", floatingTenor: " + Arrays.toString(this.floatSchedules) + ", fixTenor: " + Arrays.toString(this.fixSchedules) + "]";
    }

    public static enum SwaptionType {
        PAYER,
        RECEIVER;

    }
}

