/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class CMSOption
extends AbstractLIBORMonteCarloProduct {
    private final double exerciseDate;
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] periodLengths;
    private final double strike;

    public CMSOption(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] periodLengths, double strike) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = periodLengths;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable valueFixLeg = new RandomVariableFromDoubleArray(this.fixingDates[this.fixingDates.length - 1], 0.0);
        RandomVariable valueFloatLeg = new RandomVariableFromDoubleArray(this.paymentDates[this.paymentDates.length - 1], -1.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double periodLength = this.periodLengths != null ? this.periodLengths[period] : paymentDate - fixingDate;
            RandomVariable libor = model.getLIBOR(this.exerciseDate, fixingDate, paymentDate);
            RandomVariableFromDoubleArray payoff = new RandomVariableFromDoubleArray(paymentDate, 1.0 * periodLength);
            valueFixLeg = valueFixLeg.add(payoff);
            valueFloatLeg = valueFloatLeg.discount(libor, periodLength);
            valueFixLeg = valueFixLeg.discount(libor, periodLength);
        }
        valueFloatLeg = valueFloatLeg.add(1.0);
        RandomVariable parSwapRate = valueFloatLeg.div(valueFixLeg);
        RandomVariable payoffUnit = new RandomVariableFromDoubleArray(this.paymentDates[0], this.periodLengths[0]);
        payoffUnit = payoffUnit.discount(model.getLIBOR(this.exerciseDate, this.fixingDates[0], this.paymentDates[0]), this.paymentDates[0] - this.fixingDates[0]);
        RandomVariable value = parSwapRate.sub(this.strike).floor(0.0).mult(payoffUnit);
        if (this.fixingDates[0] != this.exerciseDate) {
            RandomVariable libor = model.getLIBOR(this.exerciseDate, this.exerciseDate, this.fixingDates[0]);
            double periodLength = this.fixingDates[0] - this.exerciseDate;
            value = value.discount(libor, periodLength);
        }
        RandomVariable numeraire = model.getNumeraire(this.exerciseDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(model.getTimeIndex(this.exerciseDate));
        value = value.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return value;
    }

    public double getValue(ForwardCurve forwardCurve, double swaprateVolatility) {
        double[] swapTenor = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, swapTenor, 0, this.fixingDates.length);
        swapTenor[swapTenor.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        TimeDiscretizationFromArray fixTenor = new TimeDiscretizationFromArray(swapTenor);
        TimeDiscretizationFromArray floatTenor = new TimeDiscretizationFromArray(swapTenor);
        double forwardSwapRate = Swap.getForwardSwapRate(fixTenor, floatTenor, forwardCurve);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretization)fixTenor, forwardCurve);
        double payoffUnit = SwapAnnuity.getSwapAnnuity((TimeDiscretization)new TimeDiscretizationFromArray(swapTenor[0], swapTenor[1]), forwardCurve) / (swapTenor[1] - swapTenor[0]);
        return AnalyticFormulas.huntKennedyCMSOptionValue(forwardSwapRate, swaprateVolatility, swapAnnuity, this.exerciseDate, swapTenor[swapTenor.length - 1] - swapTenor[0], payoffUnit, this.strike) * (swapTenor[1] - swapTenor[0]);
    }
}

