/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class Caplet
extends AbstractLIBORMonteCarloProduct {
    private final double maturity;
    private final double periodLength;
    private final double strike;
    private final double daycountFraction;
    private final boolean isFloorlet;
    private final ValueUnit valueUnit;

    public Caplet(double maturity, double periodLength, double strike, double daycountFraction, boolean isFloorlet, ValueUnit valueUnit) {
        this.maturity = maturity;
        this.periodLength = periodLength;
        this.strike = strike;
        this.daycountFraction = daycountFraction;
        this.isFloorlet = isFloorlet;
        this.valueUnit = valueUnit;
    }

    public Caplet(double maturity, double periodLength, double strike, boolean isFloorlet) {
        this(maturity, periodLength, strike, periodLength, isFloorlet, ValueUnit.VALUE);
    }

    public Caplet(double maturity, double periodLength, double strike) {
        this(maturity, periodLength, strike, false);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double paymentDate = this.maturity + this.periodLength;
        RandomVariable libor = model.getLIBOR(this.maturity, this.maturity, this.maturity + this.periodLength);
        RandomVariable numeraire = model.getNumeraire(paymentDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
        RandomVariable values = libor;
        values = !this.isFloorlet ? values.sub(this.strike).floor(0.0).mult(this.daycountFraction) : values.sub(this.strike).cap(0.0).mult(-1.0 * this.daycountFraction);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtValuationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtValuationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtValuationTime).div(monteCarloProbabilitiesAtValuationTime);
        if (this.valueUnit == ValueUnit.VALUE) {
            return values;
        }
        if (this.valueUnit == ValueUnit.LOGNORMALVOLATILITY || this.valueUnit == ValueUnit.VOLATILITY) {
            double forward = libor.div(numeraire).mult(monteCarloProbabilities).mult(numeraireAtValuationTime).div(monteCarloProbabilitiesAtValuationTime).getAverage();
            double optionMaturity = this.maturity - evaluationTime;
            double optionStrike = this.strike;
            double payoffUnit = this.daycountFraction;
            return model.getRandomVariableForConstant(AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, values.getAverage()));
        }
        if (this.valueUnit == ValueUnit.NORMALVOLATILITY) {
            double forward = libor.div(numeraire).mult(monteCarloProbabilities).mult(numeraireAtValuationTime).div(monteCarloProbabilitiesAtValuationTime).getAverage();
            double optionMaturity = this.maturity - evaluationTime;
            double optionStrike = this.strike;
            double payoffUnit = this.daycountFraction;
            return model.getRandomVariableForConstant(AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, values.getAverage()));
        }
        throw new IllegalArgumentException("Value unit " + (Object)((Object)this.valueUnit) + " unsupported.");
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY,
        INTEGRATEDLOGNORMALVARIANCE,
        LOGNORMALVOLATILITY,
        INTEGRATEDNORMALVARIANCE,
        NORMALVOLATILITY;

    }
}

