/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class DigitalCaplet
extends AbstractLIBORMonteCarloProduct {
    private final double optionMaturity;
    private final double periodStart;
    private final double periodEnd;
    private final double strike;

    public DigitalCaplet(double optionMaturity, double periodStart, double periodEnd, double strike) {
        this.optionMaturity = optionMaturity;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double paymentDate = this.periodEnd;
        double periodLength = this.periodEnd - this.periodStart;
        RandomVariable libor = model.getLIBOR(this.optionMaturity, this.periodStart, this.periodEnd);
        RandomVariable trigger = libor.sub(this.strike).mult(periodLength);
        RandomVariable values = trigger.choose(new RandomVariableFromDoubleArray(periodLength), new RandomVariableFromDoubleArray(0.0));
        RandomVariable numeraire = model.getNumeraire(paymentDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }
}

