/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class DigitalFloorlet
extends AbstractLIBORMonteCarloProduct {
    private final double maturity;
    private final double strike;

    public DigitalFloorlet(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        int liborIndex = model.getLiborPeriodIndex(this.maturity);
        double paymentDate = model.getLiborPeriod(liborIndex + 1);
        double periodLength = paymentDate - this.maturity;
        RandomVariable libor = model.getLIBOR(this.maturity, this.maturity, paymentDate);
        double[] payoff = new double[model.getNumberOfPaths()];
        for (int path = 0; path < model.getNumberOfPaths(); ++path) {
            double liborOnPath = libor.get(path);
            payoff[path] = liborOnPath < this.strike ? periodLength : 0.0;
        }
        RandomVariable numeraire = model.getNumeraire(paymentDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        RandomVariableFromDoubleArray values = new RandomVariableFromDoubleArray(paymentDate, payoff);
        values.div(numeraire).mult(monteCarloProbabilities);
        values.div(numeraireAtEvaluationTime).mult(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }
}

