/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class MoneyMarketAccount
extends AbstractLIBORMonteCarloProduct {
    private double inceptionTime = 0.0;
    private double initialValue = 1.0;
    private double accrualPeriod = -1.0;

    public MoneyMarketAccount(double inceptionTime, double initialValue, double accrualPeriod) {
        this.inceptionTime = inceptionTime;
        this.initialValue = initialValue;
        this.accrualPeriod = accrualPeriod;
    }

    public MoneyMarketAccount(double inceptionTime, double accrualPeriod) {
        this(inceptionTime, 1.0, accrualPeriod);
    }

    public MoneyMarketAccount() {
        this(0.0, 1.0, -1.0);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.inceptionTime > evaluationTime) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        if (this.accrualPeriod <= 0.0) {
            return new RandomVariableFromDoubleArray(Double.MAX_VALUE);
        }
        RandomVariable value = new RandomVariableFromDoubleArray(this.initialValue);
        for (double time = this.inceptionTime; time < evaluationTime; time += this.accrualPeriod) {
            RandomVariable forwardRate = model.getLIBOR(time, time, time + this.accrualPeriod);
            double currentAccrualPeriod = Math.min(this.accrualPeriod, evaluationTime - time);
            value = value.accrue(forwardRate, currentAccrualPeriod);
        }
        return value;
    }
}

