/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class SimpleCappedFlooredFloatingRateBond
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] spreads;
    private final double[] floors;
    private final double[] caps;
    private final double maturity;

    public SimpleCappedFlooredFloatingRateBond(String currency, double[] fixingDates, double[] paymentDates, double[] spreads, double[] floors, double[] caps, double maturity) {
        super(currency);
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.spreads = spreads;
        this.floors = floors;
        this.caps = caps;
        this.maturity = maturity;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        for (int periodIndex = 0; periodIndex < this.fixingDates.length; ++periodIndex) {
            double fixingDate = this.fixingDates[periodIndex];
            double paymentDate = this.paymentDates[periodIndex];
            double periodLength = paymentDate - fixingDate;
            RandomVariable coupon = model.getLIBOR(fixingDate, fixingDate, paymentDate);
            if (this.spreads != null) {
                coupon = coupon.sub(this.spreads[periodIndex]);
            }
            if (this.floors != null) {
                coupon = coupon.floor(this.floors[periodIndex]);
            }
            if (this.caps != null) {
                coupon = coupon.cap(this.caps[periodIndex]);
            }
            coupon = coupon.mult(periodLength);
            RandomVariable numeraire = model.getNumeraire(paymentDate);
            RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            value = value.add(coupon.div(numeraire).mult(monteCarloProbabilities));
        }
        RandomVariable notionalPayoff = model.getRandomVariableForConstant(1.0);
        RandomVariable numeraire = model.getNumeraire(this.maturity);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(this.maturity);
        value = value.add(notionalPayoff.div(numeraire).mult(monteCarloProbabilities));
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return value;
    }
}

