/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class SimpleSwap
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] swaprates;
    private final boolean isPayFix;
    private final double[] notional;

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates, boolean isPayFix, double[] notional) {
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.swaprates = swaprates;
        this.isPayFix = isPayFix;
        this.notional = notional;
    }

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates, boolean isPayFix, double notional) {
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.swaprates = swaprates;
        this.isPayFix = isPayFix;
        this.notional = new double[swaprates.length];
        Arrays.fill(this.notional, notional);
    }

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates, double notional) {
        this(fixingDates, paymentDates, swaprates, true, notional);
    }

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates, double[] notional) {
        this(fixingDates, paymentDates, swaprates, true, notional);
    }

    @Deprecated
    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this(fixingDates, paymentDates, swaprates, true, 1.0);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        for (int period = 0; period < this.fixingDates.length; ++period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double swaprate = this.swaprates[period];
            double periodLength = paymentDate - fixingDate;
            if (paymentDate < evaluationTime) continue;
            RandomVariable libor = model.getLIBOR(fixingDate, fixingDate, paymentDate);
            RandomVariable payoff = libor.sub(swaprate).mult(periodLength).mult(this.notional[period]);
            if (!this.isPayFix) {
                payoff = payoff.mult(-1.0);
            }
            RandomVariable numeraire = model.getNumeraire(paymentDate);
            RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            values = values.add(payoff);
        }
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }

    @Override
    public String toString() {
        return super.toString() + "\nfixingDates: " + Arrays.toString(this.fixingDates) + "\npaymentDates: " + Arrays.toString(this.paymentDates) + "\nswaprates: " + Arrays.toString(this.swaprates);
    }

    public double getStartTime() {
        return this.fixingDates[0];
    }

    public double[] getFixingDates() {
        return this.fixingDates;
    }

    public double[] getNotional() {
        return this.notional;
    }

    public double[] getSwapRates() {
        return this.swaprates;
    }

    public double[] getPaymentDates() {
        return this.paymentDates;
    }

    public double[] getPeriodLengths() {
        double[] periodLengths = new double[this.paymentDates.length];
        periodLengths = IntStream.range(0, periodLengths.length).mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return SimpleSwap.this.paymentDates[i] - SimpleSwap.this.fixingDates[i];
            }
        }).toArray();
        return periodLengths;
    }
}

