/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SimpleSwap;
import net.finmath.montecarlo.interestrate.products.SwapLeg;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.Schedule;

public class Swap
extends AbstractLIBORMonteCarloProduct {
    private final TermStructureMonteCarloProduct legReceiver;
    private final TermStructureMonteCarloProduct legPayer;

    public Swap(TermStructureMonteCarloProduct legReceiver, TermStructureMonteCarloProduct legPayer) {
        this.legReceiver = legReceiver;
        this.legPayer = legPayer;
    }

    public Swap(Notional notional, Schedule scheduleReceiveLeg, AbstractIndex indexReceiveLeg, double spreadReceiveLeg, Schedule schedulePayLeg, AbstractIndex indexPayLeg, double spreadPayLeg) {
        this.legReceiver = new SwapLeg(scheduleReceiveLeg, notional, indexReceiveLeg, spreadReceiveLeg, false);
        this.legPayer = new SwapLeg(schedulePayLeg, notional, indexPayLeg, spreadPayLeg, false);
    }

    @Deprecated
    public Swap(double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this.legReceiver = new SimpleSwap(fixingDates, paymentDates, swaprates);
        this.legPayer = null;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable value = this.legReceiver.getValue(evaluationTime, model);
        if (this.legPayer != null) {
            value = value.sub(this.legPayer.getValue(evaluationTime, model));
        }
        return value;
    }

    @Override
    public String toString() {
        return "Swap [legReceiver=" + this.legReceiver + ", legPayer=" + this.legPayer + "]";
    }
}

