/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximationRebonato;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.time.TimeDiscretization;

public class SwaptionFactory {
    private SwaptionFactory() {
    }

    public static TermStructureMonteCarloProduct createSwaption(String className, double swaprate, TimeDiscretization swapTenor, String valueUnitAsString) {
        if (className.equals("SwaptionAnalyticApproximation")) {
            Swaption.ValueUnit valueUnit = Swaption.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionAnalyticApproximation(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        if (className.equals("SwaptionSimple")) {
            Swaption.ValueUnit valueUnit = Swaption.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionSimple(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        if (className.equals("SwaptionAnalyticApproximationRebonato")) {
            Swaption.ValueUnit valueUnit = Swaption.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionAnalyticApproximationRebonato(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        throw new RuntimeException("Unknown class: " + className);
    }
}

