/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionSingleCurve
extends AbstractLIBORMonteCarloProduct {
    private final double exerciseDate;
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] periodLengths;
    private final double[] swaprates;

    public SwaptionSingleCurve(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] periodLengths, double[] swaprates) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = periodLengths;
        this.swaprates = swaprates;
    }

    public SwaptionSingleCurve(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = null;
        this.swaprates = swaprates;
    }

    public SwaptionSingleCurve(double exerciseDate, TimeDiscretization swapTenor, double swaprate) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = new double[swapTenor.getNumberOfTimeSteps()];
        this.paymentDates = new double[swapTenor.getNumberOfTimeSteps()];
        for (int periodIndex = 0; periodIndex < this.fixingDates.length; ++periodIndex) {
            this.fixingDates[periodIndex] = swapTenor.getTime(periodIndex);
            this.paymentDates[periodIndex] = swapTenor.getTime(periodIndex + 1);
        }
        this.periodLengths = null;
        this.swaprates = new double[swapTenor.getNumberOfTimeSteps()];
        Arrays.fill(this.swaprates, swaprate);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable valueOfSwapAtExerciseDate = model.getRandomVariableForConstant(0.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double swaprate = this.swaprates[period];
            double periodLength = this.periodLengths != null ? this.periodLengths[period] : paymentDate - fixingDate;
            RandomVariable libor = model.getLIBOR(this.exerciseDate, fixingDate, paymentDate);
            RandomVariable payoff = libor.sub(swaprate).mult(periodLength);
            valueOfSwapAtExerciseDate = valueOfSwapAtExerciseDate.add(payoff);
            valueOfSwapAtExerciseDate = valueOfSwapAtExerciseDate.discount(libor, paymentDate - fixingDate);
        }
        if (this.fixingDates[0] != this.exerciseDate) {
            RandomVariable libor = model.getLIBOR(this.exerciseDate, this.exerciseDate, this.fixingDates[0]);
            double periodLength = this.fixingDates[0] - this.exerciseDate;
            valueOfSwapAtExerciseDate = valueOfSwapAtExerciseDate.discount(libor, periodLength);
        }
        RandomVariable values = valueOfSwapAtExerciseDate.floor(0.0);
        RandomVariable numeraire = model.getNumeraire(this.exerciseDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(model.getTimeIndex(this.exerciseDate));
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return values;
    }

    public double getValue(ForwardCurve forwardCurve, double swaprateVolatility) {
        double swaprate = this.swaprates[0];
        for (double swaprate1 : this.swaprates) {
            if (swaprate1 == swaprate) continue;
            throw new RuntimeException("Uneven swaprates not allows for analytical pricing.");
        }
        double[] swapTenor = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, swapTenor, 0, this.fixingDates.length);
        swapTenor[swapTenor.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        double forwardSwapRate = Swap.getForwardSwapRate(new TimeDiscretizationFromArray(swapTenor), new TimeDiscretizationFromArray(swapTenor), forwardCurve);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretization)new TimeDiscretizationFromArray(swapTenor), forwardCurve);
        return AnalyticFormulas.blackModelSwaptionValue(forwardSwapRate, swaprateVolatility, this.exerciseDate, swaprate, swapAnnuity);
    }

    @Override
    public String toString() {
        return super.toString() + "\nexerciseDate: " + this.exerciseDate + "\nfixingDates: " + Arrays.toString(this.fixingDates) + "\npaymentDates: " + Arrays.toString(this.paymentDates) + "\nperiodLengths: " + Arrays.toString(this.periodLengths) + "\nswaprates: " + Arrays.toString(this.swaprates);
    }
}

