/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.finmath.concurrency.FutureWrapper;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;

public class Choice
extends AbstractProductComponent {
    private static final long serialVersionUID = 3211126102506873636L;
    private final double exerciseDate;
    private final TermStructureMonteCarloProduct underlying1;
    private final TermStructureMonteCarloProduct underlying2;

    public Choice(double exerciseDate, TermStructureMonteCarloProduct underlying1, TermStructureMonteCarloProduct underlying2) {
        this.exerciseDate = exerciseDate;
        this.underlying1 = underlying1;
        this.underlying2 = underlying2;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = null;
        for (TermStructureMonteCarloProduct product : new TermStructureMonteCarloProduct[]{this.underlying1, this.underlying2}) {
            if (!(product instanceof AbstractProductComponent)) continue;
            Set<String> productUnderlyingNames = ((AbstractProductComponent)product).queryUnderlyings();
            if (productUnderlyingNames != null) {
                if (underlyingNames == null) {
                    underlyingNames = productUnderlyingNames;
                    continue;
                }
                underlyingNames.addAll(productUnderlyingNames);
                continue;
            }
            throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
        }
        return underlyingNames;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, final LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        Future<RandomVariable> valueUnderlying2Future;
        Future<RandomVariable> valueUnderlying1Future;
        if (evaluationTime > this.exerciseDate) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        try {
            valueUnderlying1Future = Choice.getExecutor().submit(new Callable<RandomVariable>(){

                @Override
                public RandomVariable call() throws CalculationException {
                    return Choice.this.underlying1.getValue(Choice.this.exerciseDate, model);
                }
            });
        }
        catch (RejectedExecutionException e) {
            valueUnderlying1Future = new FutureWrapper<RandomVariable>(this.underlying1.getValue(this.exerciseDate, model));
        }
        try {
            valueUnderlying2Future = Choice.getExecutor().submit(new Callable<RandomVariable>(){

                @Override
                public RandomVariable call() throws CalculationException {
                    return Choice.this.underlying2.getValue(Choice.this.exerciseDate, model);
                }
            });
        }
        catch (RejectedExecutionException e) {
            valueUnderlying2Future = new FutureWrapper<RandomVariable>(this.underlying2.getValue(this.exerciseDate, model));
        }
        RandomVariable valueUnderlying1 = null;
        RandomVariable valueUnderlying2 = null;
        try {
            valueUnderlying1 = valueUnderlying1Future.get();
            valueUnderlying2 = valueUnderlying2Future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        RandomVariable triggerValues = valueUnderlying1.sub(valueUnderlying2);
        MonteCarloConditionalExpectationRegression conditionalExpectationOperator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.exerciseDate, model));
        RandomVariable triggerExpectedValues = triggerValues.getConditionalExpectation(conditionalExpectationOperator);
        RandomVariable values = triggerExpectedValues.choose(valueUnderlying1, valueUnderlying2);
        if (evaluationTime != this.exerciseDate) {
            RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariable numeraire = model.getNumeraire(this.exerciseDate);
            values.div(numeraire).mult(numeraireAtEval);
        }
        return values;
    }

    private RandomVariable[] getRegressionBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariable rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2;
        double periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        if (periodLength2 != periodLength1) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
        }
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = model.getNumberOfLibors();
        double periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        if (periodLength3 != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
        }
        return basisFunctions.toArray(new RandomVariable[0]);
    }
}

