/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class ExpectedTailLoss
extends AbstractProductComponent {
    private static final long serialVersionUID = 3211126102506873636L;
    private final double exerciseDate;
    private final double quantile;
    private final TermStructureMonteCarloProduct underlying;

    public ExpectedTailLoss(double exerciseDate, double quantile, TermStructureMonteCarloProduct underlying) {
        this.exerciseDate = exerciseDate;
        this.quantile = quantile;
        this.underlying = underlying;
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        if (evaluationTime > this.exerciseDate) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        RandomVariable values = this.underlying.getValue(this.exerciseDate, model);
        MonteCarloConditionalExpectationRegression conditionalExpectationOperator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.exerciseDate, model));
        RandomVariable underlyingExpectedValues = values.getConditionalExpectation(conditionalExpectationOperator);
        double quantileValue = underlyingExpectedValues.getQuantile(this.quantile);
        values = values.sub(quantileValue).choose(values, new Scalar(0.0));
        if (evaluationTime != this.exerciseDate) {
            RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariable numeraire = model.getNumeraire(this.exerciseDate);
            values = values.div(numeraire).mult(numeraireAtEval);
        }
        return values;
    }

    private RandomVariable[] getRegressionBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariable rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2;
        double periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        if (periodLength2 != periodLength1) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
        }
        basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = model.getNumberOfLibors();
        double periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        if (periodLength3 != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
        }
        return basisFunctions.toArray(new RandomVariable[0]);
    }
}

