/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.stochastic.RandomVariable;

public class NotionalFromComponent
implements Notional {
    private final AbstractProductComponent notional;

    public NotionalFromComponent(AbstractProductComponent notional) {
        this.notional = notional;
    }

    @Override
    public String getCurrency() {
        return this.notional.getCurrency();
    }

    @Override
    public RandomVariable getNotionalAtPeriodEnd(AbstractPeriod period, LIBORModelMonteCarloSimulationModel model) {
        return this.getNotionalAtPeriodStart(period, model);
    }

    @Override
    public RandomVariable getNotionalAtPeriodStart(AbstractPeriod period, LIBORModelMonteCarloSimulationModel model) {
        RandomVariable notionalValue = null;
        try {
            notionalValue = this.notional.getValue(period.getPeriodStart(), model);
        }
        catch (CalculationException e) {
            throw new IllegalArgumentException(e);
        }
        if (notionalValue.getFiltrationTime() > period.getPeriodStart()) {
            throw new IllegalArgumentException("Notional request at " + period.getPeriodStart() + "reports measuabiblity for time " + notionalValue.getFiltrationTime());
        }
        return notionalValue;
    }
}

