/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.stochastic.RandomVariable;

public class NotionalFromConstant
implements Notional {
    private final String currency;
    private final RandomVariableFromDoubleArray notional;

    public NotionalFromConstant(double notional, String currency) {
        this.notional = new RandomVariableFromDoubleArray(0.0, notional);
        this.currency = currency;
    }

    public NotionalFromConstant(double notional) {
        this(notional, null);
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    @Override
    public RandomVariable getNotionalAtPeriodEnd(AbstractPeriod period, LIBORModelMonteCarloSimulationModel model) {
        return this.notional;
    }

    @Override
    public RandomVariable getNotionalAtPeriodStart(AbstractPeriod period, LIBORModelMonteCarloSimulationModel model) {
        return this.notional;
    }

    public String toString() {
        return "Notional [currency=" + this.currency + ", notional=" + this.notional + "]";
    }
}

