/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.conditionalexpectation.RegressionBasisFunctionsProvider;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class Option
extends AbstractProductComponent
implements RegressionBasisFunctionsProvider {
    private static final long serialVersionUID = 2987369289230532162L;
    private final double exerciseDate;
    private final double strikePrice;
    private final AbstractLIBORMonteCarloProduct underlying;
    private final TermStructureMonteCarloProduct strikeProduct;
    private final boolean isCall;
    private final RegressionBasisFunctionsProvider regressionBasisFunctionsProvider;

    public Option(double exerciseDate, double strikePrice, boolean isCall, AbstractLIBORMonteCarloProduct underlying, RegressionBasisFunctionsProvider regressionBasisFunctionsProvider) {
        this.exerciseDate = exerciseDate;
        this.strikePrice = strikePrice;
        this.underlying = underlying;
        this.isCall = isCall;
        this.strikeProduct = null;
        this.regressionBasisFunctionsProvider = regressionBasisFunctionsProvider;
    }

    public Option(double exerciseDate, boolean isCall, TermStructureMonteCarloProduct strikeProduct, AbstractLIBORMonteCarloProduct underlying, RegressionBasisFunctionsProvider regressionBasisFunctionsProvider) {
        this.exerciseDate = exerciseDate;
        this.strikePrice = Double.NaN;
        this.strikeProduct = strikeProduct;
        this.underlying = underlying;
        this.isCall = isCall;
        this.regressionBasisFunctionsProvider = regressionBasisFunctionsProvider;
    }

    public Option(double exerciseDate, boolean isCall, TermStructureMonteCarloProduct strikeProduct, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, isCall, strikeProduct, underlying, null);
    }

    public Option(double exerciseDate, double strikePrice, boolean isCall, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, strikePrice, isCall, underlying, null);
    }

    public Option(double exerciseDate, double strikePrice, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, strikePrice, true, underlying);
    }

    public Option(double exerciseDate, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, 0.0, underlying);
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = null;
        for (TermStructureMonteCarloProduct product : new TermStructureMonteCarloProduct[]{this.underlying, this.strikeProduct}) {
            if (!(product instanceof AbstractProductComponent)) continue;
            Set<String> productUnderlyingNames = ((AbstractProductComponent)product).queryUnderlyings();
            if (productUnderlyingNames != null) {
                if (underlyingNames == null) {
                    underlyingNames = productUnderlyingNames;
                    continue;
                }
                underlyingNames.addAll(productUnderlyingNames);
                continue;
            }
            throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
        }
        return underlyingNames;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable strike;
        RandomVariable one = model.getRandomVariableForConstant(1.0);
        RandomVariable zero = model.getRandomVariableForConstant(0.0);
        if (evaluationTime > this.exerciseDate) {
            return zero;
        }
        RandomVariable values = this.underlying.getValue(this.exerciseDate, model);
        RandomVariable exerciseTrigger = values.sub(strike = this.strikeProduct != null ? this.strikeProduct.getValue(this.exerciseDate, model) : model.getRandomVariableForConstant(this.strikePrice)).mult(this.isCall ? 1.0 : -1.0);
        if (exerciseTrigger.getFiltrationTime() > this.exerciseDate) {
            RandomVariable filterNaN = exerciseTrigger.isNaN().sub(1.0).mult(-1.0);
            RandomVariable exerciseTriggerFiltered = exerciseTrigger.mult(filterNaN);
            double exerciseTriggerMean = exerciseTriggerFiltered.getAverage();
            double exerciseTriggerStdDev = exerciseTriggerFiltered.getStandardDeviation();
            double exerciseTriggerFloor = exerciseTriggerMean * (1.0 - Math.signum(exerciseTriggerMean) * 1.0E-5) - 3.0 * exerciseTriggerStdDev;
            double exerciseTriggerCap = exerciseTriggerMean * (1.0 + Math.signum(exerciseTriggerMean) * 1.0E-5) + 3.0 * exerciseTriggerStdDev;
            RandomVariable filter = exerciseTrigger.sub(exerciseTriggerFloor).choose(one, zero).mult(exerciseTrigger.sub(exerciseTriggerCap).mult(-1.0).choose(one, zero));
            filter = filter.mult(filterNaN);
            exerciseTrigger = exerciseTrigger.mult(filter);
            RandomVariable[] regressionBasisFunctions = this.regressionBasisFunctionsProvider != null ? this.regressionBasisFunctionsProvider.getBasisFunctions(evaluationTime, model) : this.getBasisFunctions(this.exerciseDate, model);
            RandomVariable[] filteredRegressionBasisFunctions = new RandomVariable[regressionBasisFunctions.length];
            for (int i = 0; i < regressionBasisFunctions.length; ++i) {
                filteredRegressionBasisFunctions[i] = regressionBasisFunctions[i].mult(filter);
            }
            MonteCarloConditionalExpectationRegression conditionalExpectationOperator = new MonteCarloConditionalExpectationRegression(filteredRegressionBasisFunctions, regressionBasisFunctions);
            exerciseTrigger = exerciseTrigger.getConditionalExpectation(conditionalExpectationOperator);
        }
        values = this.strikeProduct != null ? exerciseTrigger.choose(values, this.strikeProduct.getValue(this.exerciseDate, model)) : exerciseTrigger.choose(values, new Scalar(this.strikePrice));
        if (evaluationTime != this.exerciseDate) {
            RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariable numeraire = model.getNumeraire(this.exerciseDate);
            values = values.div(numeraire).mult(numeraireAtEval);
        }
        return values;
    }

    @Override
    public RandomVariable[] getBasisFunctions(double evaluationTime, MonteCarloSimulationModel model) throws CalculationException {
        if (model instanceof LIBORModelMonteCarloSimulationModel) {
            return this.getBasisFunctions(evaluationTime, (LIBORModelMonteCarloSimulationModel)model);
        }
        throw new IllegalArgumentException("getBasisFunctions requires an model of type LIBORModelMonteCarloSimulationModel.");
    }

    public RandomVariable[] getBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double periodLength3;
        double periodLength2;
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = model.getRandomVariableForConstant(1.0);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariable rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunction = basisFunction.discount(rate, periodLength2);
        }
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd = model.getNumberOfLibors()) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
        }
        return basisFunctions.toArray(new RandomVariable[0]);
    }

    @Override
    public String toString() {
        return "Option [exerciseDate=" + this.exerciseDate + ", strikePrice=" + this.strikePrice + ", underlying=" + this.underlying + ", isCall=" + this.isCall + ", toString()=" + super.toString() + "]";
    }
}

