/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class Period
extends AbstractPeriod {
    private static final long serialVersionUID = -7107623461781510475L;
    private final boolean couponFlow;
    private final boolean notionalFlow;
    private final boolean payer;
    private final boolean isExcludeAccruedInterest;

    public Period(LocalDateTime referenceDate, double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, double daycountFraction, boolean couponFlow, boolean notionalFlow, boolean payer, boolean isExcludeAccruedInterest) {
        super(referenceDate, periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction);
        this.couponFlow = couponFlow;
        this.notionalFlow = notionalFlow;
        this.payer = payer;
        this.isExcludeAccruedInterest = isExcludeAccruedInterest;
    }

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, double daycountFraction, boolean couponFlow, boolean notionalFlow, boolean payer, boolean isExcludeAccruedInterest) {
        this(null, periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction, couponFlow, notionalFlow, payer, isExcludeAccruedInterest);
    }

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, double daycountFraction, boolean couponFlow, boolean notionalFlow, boolean payer) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction, couponFlow, notionalFlow, payer, false);
    }

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, boolean couponFlow, boolean notionalFlow, boolean payer) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, periodEnd - periodStart, couponFlow, notionalFlow, payer);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values;
        double productToModelTimeOffset = 0.0;
        try {
            if (this.getReferenceDate() != null && model.getReferenceDate() != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), this.getReferenceDate());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (evaluationTime >= productToModelTimeOffset + this.getPaymentDate()) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        RandomVariable notionalAtPeriodStart = this.getNotional().getNotionalAtPeriodStart(this, model);
        RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
        RandomVariable numeraire = model.getNumeraire(productToModelTimeOffset + this.getPaymentDate());
        if (this.couponFlow) {
            values = this.getCoupon(productToModelTimeOffset + this.getFixingDate(), model);
            values = values.mult(notionalAtPeriodStart);
            values = values.div(numeraire);
            if (this.isExcludeAccruedInterest && evaluationTime >= productToModelTimeOffset + this.getPeriodStart() && evaluationTime < productToModelTimeOffset + this.getPeriodEnd()) {
                double nonAccruedInterestRatio = (productToModelTimeOffset + this.getPeriodEnd() - evaluationTime) / (this.getPeriodEnd() - this.getPeriodStart());
                values = values.mult(nonAccruedInterestRatio);
            }
        } else {
            values = new RandomVariableFromDoubleArray(0.0, 0.0);
        }
        if (this.notionalFlow) {
            RandomVariable notionalAtPeriodEnd = this.getNotional().getNotionalAtPeriodEnd(this, model);
            if (this.getPeriodStart() > evaluationTime) {
                RandomVariable numeraireAtPeriodStart = model.getNumeraire(this.getPeriodStart());
                values = values.subRatio(notionalAtPeriodStart, numeraireAtPeriodStart);
            }
            if (this.getPeriodEnd() > evaluationTime) {
                RandomVariable numeraireAtPeriodEnd = model.getNumeraire(this.getPeriodEnd());
                values = values.addRatio(notionalAtPeriodEnd, numeraireAtPeriodEnd);
            }
        }
        if (this.payer) {
            values = values.mult(-1.0);
        }
        values = values.mult(numeraireAtEval);
        return values;
    }

    @Override
    public RandomVariable getCoupon(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = this.getIndex().getValue(evaluationTime, model);
        double periodDaycountFraction = this.getDaycountFraction();
        values = values.mult(periodDaycountFraction);
        return values;
    }

    @Override
    public String toString() {
        return "Period [couponFlow=" + this.couponFlow + ", notionalFlow=" + this.notionalFlow + ", payer=" + this.payer + ", toString()=" + super.toString() + "]";
    }
}

