/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.daycount.DayCountConvention;

public class AccruedInterest
extends AbstractIndex {
    private static final long serialVersionUID = 147619920344514766L;
    private final LocalDate referenceDate;
    private final LocalDate periodStartDate;
    private final LocalDate periodEndDate;
    private final AbstractIndex index;
    private final Double indexFixingTime;
    private final DayCountConvention daycountConvention;
    private final boolean isNegativeAccruedInterest;

    public AccruedInterest(String name, String currency, LocalDate referenceDate, LocalDate periodStartDate, LocalDate periodEndDate, AbstractIndex index, Double indexFixingTime, DayCountConvention daycountConvention, boolean isNegativeAccruedInterest) {
        super(name, currency);
        this.referenceDate = referenceDate;
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
        this.index = index;
        this.indexFixingTime = indexFixingTime;
        this.daycountConvention = daycountConvention;
        this.isNegativeAccruedInterest = isNegativeAccruedInterest;
    }

    @Override
    public RandomVariable getValue(double fixingTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double daycountFraction = this.daycountConvention.getDaycountFraction(this.periodStartDate, this.getModelDate(fixingTime));
        double daycountPeriod = this.daycountConvention.getDaycountFraction(this.periodStartDate, this.periodEndDate);
        daycountFraction = Math.min(Math.max(daycountFraction, 0.0), daycountPeriod);
        if (this.isNegativeAccruedInterest) {
            daycountFraction = daycountPeriod - daycountFraction;
        }
        return this.index.getValue((double)this.indexFixingTime, model).mult(daycountFraction);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.index.queryUnderlyings();
    }

    private LocalDate getModelDate(double fixingTime) {
        return this.referenceDate.plusDays(Math.round((float)(fixingTime * 365.0)));
    }
}

