/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class ConstantMaturitySwaprate
extends AbstractIndex {
    private static final long serialVersionUID = -5353191308059733179L;
    private final double fixingOffset;
    private final double[] periodLengths;

    public ConstantMaturitySwaprate(String name, String currency, double fixingOffset, double[] periodLengths) {
        super(name, currency);
        this.fixingOffset = fixingOffset;
        this.periodLengths = periodLengths;
    }

    public ConstantMaturitySwaprate(double fixingOffset, double[] periodLengths) {
        this(null, null, fixingOffset, periodLengths);
    }

    public ConstantMaturitySwaprate(double[] periodLengths) {
        this(0.0, periodLengths);
    }

    public ConstantMaturitySwaprate(String name, String currency, double fixingOffset, double maturity, double periodLength) {
        super(name, currency);
        this.fixingOffset = fixingOffset;
        int numberOfPeriods = (int)(maturity / periodLength + 0.5);
        if ((double)numberOfPeriods * periodLength != maturity) {
            throw new IllegalArgumentException("matruity not divisible by periodLength");
        }
        this.periodLengths = new double[numberOfPeriods];
        Arrays.fill(this.periodLengths, periodLength);
    }

    public ConstantMaturitySwaprate(double fixingOffset, double maturity, double periodLength) {
        this(null, null, fixingOffset, maturity, periodLength);
    }

    public ConstantMaturitySwaprate(double maturity, double periodLength) {
        this(0.0, maturity, periodLength);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable[] forwardRates = new RandomVariable[this.periodLengths.length];
        double periodStart = evaluationTime + this.fixingOffset;
        for (int periodIndex = 0; periodIndex < this.periodLengths.length; ++periodIndex) {
            forwardRates[periodIndex] = model.getLIBOR(evaluationTime + this.fixingOffset, periodStart, periodStart + this.periodLengths[periodIndex]);
            periodStart += this.periodLengths[periodIndex];
        }
        RandomVariable forwardBondInverse = model.getRandomVariableForConstant(1.0);
        RandomVariable forwardAnnuityInverse = model.getRandomVariableForConstant(this.periodLengths[this.periodLengths.length - 1]);
        for (int periodIndex = this.periodLengths.length - 1; periodIndex >= 1; --periodIndex) {
            RandomVariable forwardBondOnePeriodInverse = forwardRates[periodIndex].mult(this.periodLengths[periodIndex]).add(1.0);
            forwardBondInverse = forwardBondInverse.mult(forwardBondOnePeriodInverse);
            forwardAnnuityInverse = forwardAnnuityInverse.addProduct(forwardBondInverse, this.periodLengths[periodIndex]);
        }
        RandomVariable forwardBondOnePeriodInverse = forwardRates[0].mult(this.periodLengths[0]).add(1.0);
        forwardBondInverse = forwardBondInverse.mult(forwardBondOnePeriodInverse);
        RandomVariable swaprate = forwardBondInverse.sub(1.0).div(forwardAnnuityInverse);
        return swaprate;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "ConstantMaturitySwaprate [fixingOffset=" + this.fixingOffset + ", periodLengths=" + Arrays.toString(this.periodLengths) + "]";
    }
}

