/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public class LIBORIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final String paymentOffsetCode;
    private final BusinessdayCalendar paymentBusinessdayCalendar;
    private final BusinessdayCalendar.DateRollConvention paymentDateRollConvention;
    private final double periodStartOffset;
    private final double periodLength;

    public LIBORIndex(String name, String currency, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention) {
        super(name, currency);
        this.paymentOffsetCode = paymentOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.paymentDateRollConvention = paymentDateRollConvention;
        this.periodStartOffset = 0.0;
        this.periodLength = Double.NaN;
    }

    public LIBORIndex(String name, double periodStartOffset, double periodLength) {
        super(name, null);
        this.paymentOffsetCode = null;
        this.paymentBusinessdayCalendar = null;
        this.paymentDateRollConvention = null;
        this.periodStartOffset = periodStartOffset;
        this.periodLength = periodLength;
    }

    public LIBORIndex(double periodStartOffset, double periodLength) {
        this(null, periodStartOffset, periodLength);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.getName() != null && model.getModel().getForwardRateCurve().getName() != null && !model.getModel().getForwardRateCurve().getName().equals(this.getName()) && model.getModel().getAnalyticModel() != null && model.getModel().getAnalyticModel().getForwardCurve(this.getName()) == null) {
            throw new IllegalArgumentException("No curve for index " + this.getName() + " found in model.");
        }
        if (evaluationTime < 0.0) {
            return model.getRandomVariableForConstant(model.getModel().getForwardRateCurve().getForward(model.getModel().getAnalyticModel(), evaluationTime + this.periodStartOffset));
        }
        double periodLength = this.getPeriodLength(model, evaluationTime + this.periodStartOffset);
        RandomVariable forwardRate = model.getLIBOR(evaluationTime, evaluationTime + this.periodStartOffset, evaluationTime + this.periodStartOffset + periodLength);
        if (this.getName() != null && !model.getModel().getForwardRateCurve().getName().equals(this.getName())) {
            AnalyticModel analyticModel = model.getModel().getAnalyticModel();
            if (analyticModel == null) {
                throw new IllegalArgumentException("Index " + this.getName() + " does not aggree with model curve " + model.getModel().getForwardRateCurve().getName() + " and requires analytic model for adjustment. The analyticModel is null.");
            }
            ForwardCurve indexForwardCurve = analyticModel.getForwardCurve(this.getName());
            ForwardCurve modelForwardCurve = model.getModel().getForwardRateCurve();
            double adjustment = (1.0 + indexForwardCurve.getForward(analyticModel, evaluationTime + this.periodStartOffset, periodLength) * periodLength) / (1.0 + modelForwardCurve.getForward(analyticModel, evaluationTime + this.periodStartOffset, periodLength) * periodLength);
            forwardRate = forwardRate.mult(periodLength).add(1.0).mult(adjustment).sub(1.0).div(periodLength);
        }
        return forwardRate;
    }

    public double getPeriodStartOffset() {
        return this.periodStartOffset;
    }

    public double getPeriodLength(LIBORModelMonteCarloSimulationModel model, double fixingTime) {
        if (this.paymentOffsetCode != null) {
            LocalDateTime referenceDate = model.getReferenceDate();
            LocalDateTime fixingDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, fixingTime);
            LocalDate paymentDate = this.paymentBusinessdayCalendar.getAdjustedDate(fixingDate.toLocalDate(), this.paymentOffsetCode, this.paymentDateRollConvention);
            double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, LocalDateTime.of(paymentDate, fixingDate.toLocalTime()));
            return paymentTime - fixingTime;
        }
        return this.periodLength;
    }

    public double getPeriodLength() {
        return this.periodLength;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "LIBORIndex [periodStartOffset=" + this.periodStartOffset + ", periodLength=" + this.periodLength + ", toString()=" + super.toString() + "]";
    }
}

