/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public class LaggedIndex
extends AbstractIndex {
    private static final long serialVersionUID = 4899043672016395530L;
    private final AbstractProductComponent index;
    private final String fixingOffsetCode;
    private final BusinessdayCalendar paymentBusinessdayCalendar;
    private final double fixingOffset;

    public LaggedIndex(AbstractProductComponent index, String fixingOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar) {
        this.index = index;
        this.fixingOffsetCode = fixingOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.fixingOffset = 0.0;
    }

    public LaggedIndex(AbstractProductComponent index, double fixingOffset) {
        this.index = index;
        this.fixingOffsetCode = null;
        this.paymentBusinessdayCalendar = null;
        this.fixingOffset = fixingOffset;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.index.queryUnderlyings();
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.fixingOffsetCode != null) {
            LocalDate startDate = FloatingpointDate.getDateFromFloatingPointDate(model.getReferenceDate().toLocalDate(), evaluationTime);
            LocalDate endDate = this.paymentBusinessdayCalendar.getDateFromDateAndOffsetCode(startDate, this.fixingOffsetCode);
            double fixingOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate().toLocalDate(), endDate);
            return this.index.getValue(evaluationTime + fixingOffset, model);
        }
        return this.index.getValue(evaluationTime + this.fixingOffset, model);
    }
}

