/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Arrays;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class MinIndex
extends AbstractIndex {
    private static final long serialVersionUID = -1512137372132830198L;
    private final AbstractProductComponent[] indexArguments;

    public MinIndex(AbstractProductComponent ... indexArguments) {
        if (indexArguments.length < 1) {
            throw new IllegalArgumentException("Missing arguments. Please provide one or more arguments.");
        }
        this.indexArguments = indexArguments;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable value = this.indexArguments[0].getValue(evaluationTime, model);
        for (AbstractProductComponent index : this.indexArguments) {
            value = value.cap(index.getValue(evaluationTime, model));
        }
        return value;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = null;
        for (AbstractProductComponent product : this.indexArguments) {
            Set<String> productUnderlyingNames = product.queryUnderlyings();
            if (productUnderlyingNames == null) continue;
            if (underlyingNames == null) {
                underlyingNames = productUnderlyingNames;
                continue;
            }
            underlyingNames.addAll(productUnderlyingNames);
        }
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "MinIndex [indexArguments=" + Arrays.toString(this.indexArguments) + "]";
    }
}

