/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class ProductIndex
extends AbstractIndex {
    private static final long serialVersionUID = -8181742829635380940L;
    private final AbstractProductComponent index1;
    private final AbstractProductComponent index2;

    public ProductIndex(AbstractIndex index1, AbstractIndex index2) {
        this.index1 = index1;
        this.index2 = index2;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        return this.index1.getValue(evaluationTime, model).mult(this.index2.getValue(evaluationTime, model));
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = this.index1.queryUnderlyings();
        Set<String> underlyingNames2 = this.index2.queryUnderlyings();
        if (underlyingNames2 != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNames2);
            } else {
                underlyingNames = underlyingNames2;
            }
        }
        return underlyingNames;
    }
}

