/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class TimeDiscreteEndOfMonthIndex
extends AbstractIndex {
    private static final long serialVersionUID = -490057583438933158L;
    private final AbstractIndex baseIndex;
    private final int fixingOffsetMonths;

    public TimeDiscreteEndOfMonthIndex(String name, AbstractIndex baseIndex, int fixingOffsetMonths) {
        super(name);
        this.baseIndex = baseIndex;
        this.fixingOffsetMonths = fixingOffsetMonths;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        LocalDate referenceDate = model.getModel().getForwardRateCurve().getReferenceDate();
        LocalDate evaluationDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, evaluationTime);
        LocalDate endDate = evaluationDate.withDayOfMonth(1).plusMonths(this.fixingOffsetMonths);
        endDate = endDate.withDayOfMonth(endDate.lengthOfMonth());
        double time = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, endDate);
        return this.baseIndex.getValue(time, model);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.baseIndex.queryUnderlyings();
    }

    @Override
    public String toString() {
        return "TimeDiscreteEndOfMonthIndex [baseIndex=" + this.baseIndex + ", fixingOffsetMonths=" + this.fixingOffsetMonths + "]";
    }
}

