/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.model;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public interface ProcessModel {
    public LocalDateTime getReferenceDate();

    public int getNumberOfComponents();

    public RandomVariable applyStateSpaceTransform(MonteCarloProcess var1, int var2, int var3, RandomVariable var4);

    default public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        throw new UnsupportedOperationException("Inverse of statespace transform not set");
    }

    public RandomVariable[] getInitialState(MonteCarloProcess var1);

    public RandomVariable getNumeraire(MonteCarloProcess var1, double var2) throws CalculationException;

    public RandomVariable[] getDrift(MonteCarloProcess var1, int var2, RandomVariable[] var3, RandomVariable[] var4);

    public int getNumberOfFactors();

    public RandomVariable[] getFactorLoading(MonteCarloProcess var1, int var2, int var3, RandomVariable[] var4);

    public RandomVariable getRandomVariableForConstant(double var1);

    public ProcessModel getCloneWithModifiedData(Map<String, Object> var1) throws CalculationException;
}

