/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public abstract class MonteCarloProcessFromProcessModel
implements MonteCarloProcess,
Cloneable {
    private final ProcessModel model;
    private final TimeDiscretization timeDiscretization;

    public MonteCarloProcessFromProcessModel(TimeDiscretization timeDiscretization, ProcessModel model) {
        this.timeDiscretization = timeDiscretization;
        this.model = model;
    }

    public abstract Object getCloneWithModifiedSeed(int var1);

    @Override
    public ProcessModel getModel() {
        return this.model;
    }

    @Override
    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    public RandomVariable[] getInitialState() {
        return this.model.getInitialState(this);
    }

    public RandomVariable[] getDrift(int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return this.model.getDrift(this, timeIndex, realizationAtTimeIndex, realizationPredictor);
    }

    public RandomVariable[] getFactorLoading(int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        return this.model.getFactorLoading(this, timeIndex, componentIndex, realizationAtTimeIndex);
    }

    public RandomVariable applyStateSpaceTransform(int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return this.model.applyStateSpaceTransform(this, timeIndex, componentIndex, randomVariable);
    }

    public RandomVariable applyStateSpaceTransformInverse(int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return this.model.applyStateSpaceTransformInverse(this, timeIndex, componentIndex, randomVariable);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int timeIndex) {
        if (timeIndex < 0 || timeIndex >= this.timeDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index " + timeIndex + " for process time discretization out of bounds.");
        }
        return this.timeDiscretization.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    @Override
    public abstract MonteCarloProcessFromProcessModel clone();
}

