/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.products;

import java.util.Arrays;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.stochastic.RandomVariable;

public class PortfolioMonteCarloProduct
extends AbstractMonteCarloProduct {
    private final MonteCarloProduct[] products;
    private final double[] weights;
    private final Optional<Integer> numberOfThreads;

    public PortfolioMonteCarloProduct(MonteCarloProduct[] products, double[] weights, Optional<Integer> numberOfThreads) {
        this.products = products;
        this.weights = weights;
        this.numberOfThreads = numberOfThreads;
        if (numberOfThreads.isPresent() && numberOfThreads.get() < 1) {
            throw new IllegalArgumentException("The parameter numberOfThreads is required to be > 0 if present.");
        }
    }

    public PortfolioMonteCarloProduct(MonteCarloProduct[] products, double[] weights) {
        this(products, weights, Optional.empty());
    }

    public PortfolioMonteCarloProduct(MonteCarloProduct[] products) {
        this(products, PortfolioMonteCarloProduct.weightsOfOne(products.length));
    }

    private static double[] weightsOfOne(int length) {
        double[] weightsOfOne = new double[length];
        Arrays.fill(weightsOfOne, 1.0);
        return weightsOfOne;
    }

    @Override
    public RandomVariable getValue(final double evaluationTime, final MonteCarloSimulationModel model) throws CalculationException {
        if (this.products == null || this.products.length == 0) {
            return null;
        }
        int numberOfThreadsEffective = this.numberOfThreads.orElse(Runtime.getRuntime().availableProcessors());
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreadsEffective);
        RandomVariable value = null;
        try {
            int i;
            Vector<Future<RandomVariable>> values = new Vector<Future<RandomVariable>>(this.products.length);
            for (i = 0; i < this.products.length; ++i) {
                final MonteCarloProduct product = this.products[i];
                final double weight = this.weights[i];
                Callable<RandomVariable> worker = new Callable<RandomVariable>(){

                    @Override
                    public RandomVariable call() throws CalculationException {
                        return product.getValue(evaluationTime, model).mult(weight);
                    }
                };
                values.add(i, executor.submit(worker));
            }
            value = (RandomVariable)((Future)values.get(0)).get();
            for (i = 1; i < this.products.length; ++i) {
                value = value.add((RandomVariable)((Future)values.get(i)).get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CalculationException(e.getCause());
        }
        finally {
            executor.shutdown();
        }
        return value;
    }
}

