/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign;

import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionLazyInit;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public abstract class LogNormalProcess {
    private BrownianMotion brownianMotion;
    private RandomVariable[][] discreteProcess = null;
    private RandomVariable[] discreteProcessWeights = null;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfComponents;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private Scheme scheme = Scheme.EULER;

    public LogNormalProcess(int numberOfComponents, BrownianMotion brownianMotion) {
        this.timeDiscretization = brownianMotion.getTimeDiscretization();
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = brownianMotion.getNumberOfFactors();
        this.numberOfPaths = brownianMotion.getNumberOfPaths();
        this.brownianMotion = brownianMotion;
    }

    public LogNormalProcess(TimeDiscretization timeDiscretization, int numberOfComponents, int numberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = 1;
        this.numberOfPaths = numberOfPaths;
        this.brownianMotion = new BrownianMotionLazyInit(timeDiscretization, this.numberOfFactors, numberOfPaths, 3141);
    }

    public LogNormalProcess(TimeDiscretization timeDiscretization, int numberOfComponents, int numberOfFactors, int numberOfPaths, int seed) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.brownianMotion = new BrownianMotionLazyInit(timeDiscretization, numberOfFactors, numberOfPaths, seed);
    }

    public abstract RandomVariable[] getInitialValue();

    public abstract RandomVariable getDrift(int var1, int var2, RandomVariable[] var3, RandomVariable[] var4);

    public RandomVariable[] getDrift(int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable[] drift = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            drift[componentIndex] = this.getDrift(timeIndex, componentIndex, realizationAtTimeIndex, realizationPredictor);
        }
        return drift;
    }

    public abstract RandomVariable getFactorLoading(int var1, int var2, int var3, RandomVariable[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable[] getProcessValue(int timeIndex) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[timeIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getProcessValue(int timeIndex, int componentIndex) {
        if (timeIndex == 0) {
            return this.getInitialValue()[componentIndex];
        }
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[timeIndex][componentIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getMonteCarloWeights(int timeIndex) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[timeIndex];
    }

    private void doPrecalculateProcess() {
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        this.discreteProcess = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps() + 1][this.numberOfComponents];
        this.discreteProcessWeights = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = new RandomVariableFromDoubleArray(0.0, 1.0 / (double)this.numberOfPaths);
        this.discreteProcess[0] = this.getInitialValue();
        for (int timeIndex = 1; timeIndex < this.timeDiscretization.getNumberOfTimeSteps() + 1; ++timeIndex) {
            RandomVariable previouseRealization;
            double deltaT = this.timeDiscretization.getTime(timeIndex) - this.timeDiscretization.getTime(timeIndex - 1);
            RandomVariable[] variance = new RandomVariable[this.numberOfComponents];
            RandomVariable[] diffusion = new RandomVariable[this.numberOfComponents];
            for (int componentIndex = this.numberOfComponents - 1; componentIndex >= 0; --componentIndex) {
                RandomVariable varianceOfComponent = new RandomVariableFromDoubleArray(this.getTime(timeIndex - 1), 0.0);
                RandomVariable diffusionOfComponent = new RandomVariableFromDoubleArray(this.getTime(timeIndex - 1), 0.0);
                for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                    RandomVariable factorLoading = this.getFactorLoading(timeIndex - 1, factor, componentIndex, null);
                    RandomVariable brownianIncrement = this.brownianMotion.getBrownianIncrement(timeIndex - 1, factor);
                    varianceOfComponent = varianceOfComponent.addProduct(factorLoading, factorLoading);
                    diffusionOfComponent = diffusionOfComponent.addProduct(factorLoading, brownianIncrement);
                }
                variance[componentIndex] = varianceOfComponent;
                diffusion[componentIndex] = diffusionOfComponent;
            }
            RandomVariable[] drift = this.scheme == Scheme.PREDICTOR_USING_LASTREALIZATION ? this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], this.discreteProcess[timeIndex]) : this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], null);
            for (int componentIndex = this.numberOfComponents - 1; componentIndex >= 0; --componentIndex) {
                RandomVariable driftOfComponent = drift[componentIndex];
                RandomVariable varianceOfComponent = variance[componentIndex];
                RandomVariable diffusionOfComponent = diffusion[componentIndex];
                if (driftOfComponent == null) {
                    this.discreteProcess[timeIndex][componentIndex] = this.discreteProcess[timeIndex - 1][componentIndex];
                    continue;
                }
                double[] newRealization = new double[this.numberOfPaths];
                previouseRealization = this.discreteProcess[timeIndex - 1][componentIndex];
                for (int pathIndex = 0; pathIndex < this.numberOfPaths; ++pathIndex) {
                    double previousValue = previouseRealization.get(pathIndex);
                    double driftOnPath = driftOfComponent.get(pathIndex);
                    double varianceOnPath = varianceOfComponent.get(pathIndex);
                    double diffusionOnPath = diffusionOfComponent.get(pathIndex);
                    newRealization[pathIndex] = previousValue * Math.exp(driftOnPath * deltaT - 0.5 * varianceOnPath * deltaT + diffusionOnPath);
                }
                this.discreteProcess[timeIndex][componentIndex] = new RandomVariableFromDoubleArray(this.getTime(timeIndex), newRealization);
            }
            if (this.scheme == Scheme.PREDICTOR_USING_EULERSTEP) {
                RandomVariableFromDoubleArray[] newRealization = new RandomVariableFromDoubleArray[this.numberOfComponents];
                drift = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], this.discreteProcess[timeIndex]);
                for (int componentIndex = 0; componentIndex < this.numberOfComponents; ++componentIndex) {
                    RandomVariable driftOfComponent = drift[componentIndex];
                    RandomVariable varianceOfComponent = variance[componentIndex];
                    RandomVariable diffusionOfComponent = diffusion[componentIndex];
                    previouseRealization = this.discreteProcess[timeIndex - 1][componentIndex];
                    newRealization[componentIndex] = previouseRealization.mult(driftOfComponent.mult(deltaT).sub(varianceOfComponent.mult(0.5 * deltaT)).add(diffusionOfComponent).exp());
                }
                this.discreteProcess[timeIndex] = newRealization;
            }
            this.discreteProcessWeights[timeIndex] = this.discreteProcessWeights[timeIndex - 1];
        }
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public double getTime(int timeIndex) {
        return this.timeDiscretization.getTime(timeIndex);
    }

    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    public BrownianMotion getBrownianMotion() {
        return this.brownianMotion;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    protected synchronized void setBrownianMotion(BrownianMotion brownianMotion) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.brownianMotion = brownianMotion;
    }

    public synchronized void setScheme(Scheme scheme) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.scheme = scheme;
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_USING_EULERSTEP,
        PREDICTOR_USING_LASTREALIZATION;

    }
}

