/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.functions.LinearAlgebra;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.SolverException;

public abstract class LevenbergMarquardt
implements Serializable,
Cloneable,
Optimizer {
    private static final long serialVersionUID = 4560864869394838155L;
    private final RegularizationMethod regularizationMethod;
    private double[] initialParameters = null;
    private double[] parameterSteps = null;
    private double[] targetValues = null;
    private double[] weights = null;
    private int maxIteration = 100;
    private double lambda = 0.001;
    private double lambdaDivisor = 3.0;
    private double lambdaMultiplicator = 2.0;
    private double errorRootMeanSquaredTolerance = 0.0;
    private int iteration = 0;
    private double[] parameterTest = null;
    private double[] parameterIncrement = null;
    private double[] valueTest = null;
    private double[] parameterCurrent = null;
    private double[] valueCurrent = null;
    private double[][] derivativeCurrent = null;
    private double errorMeanSquaredCurrent = Double.POSITIVE_INFINITY;
    private double errorRootMeanSquaredChange = Double.POSITIVE_INFINITY;
    private boolean isParameterCurrentDerivativeValid = false;
    private double[][] hessianMatrix = null;
    private double[] beta = null;
    private int numberOfThreads = 1;
    private ExecutorService executor = null;
    private boolean executorShutdownWhenDone = true;
    private final Logger logger = Logger.getLogger("net.finmath");

    public static void main(String[] args) throws SolverException, CloneNotSupportedException {
        LevenbergMarquardt optimizer = new LevenbergMarquardt(){
            private static final long serialVersionUID = -282626938650139518L;

            @Override
            public void setValues(double[] parameters, double[] values) {
                values[0] = parameters[0] * 0.0 + parameters[1];
                values[1] = parameters[0] * 2.0 + parameters[1];
            }
        };
        optimizer.setInitialParameters(new double[]{0.0, 0.0});
        optimizer.setWeights(new double[]{1.0, 1.0});
        optimizer.setMaxIteration(100);
        optimizer.setTargetValues(new double[]{5.0, 10.0});
        optimizer.run();
        double[] bestParameters = optimizer.getBestFitParameters();
        System.out.println("The solver for problem 1 required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
        for (int i = 0; i < bestParameters.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + bestParameters[i]);
        }
        LevenbergMarquardt optimizer2 = optimizer.getCloneWithModifiedTargetValues(new double[]{5.1, 10.2}, new double[]{1.0, 1.0}, true);
        optimizer2.run();
        double[] bestParameters2 = optimizer2.getBestFitParameters();
        System.out.println("The solver for problem 2 required " + optimizer2.getIterations() + " iterations. The best fit parameters are:");
        for (int i = 0; i < bestParameters2.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + bestParameters2[i]);
        }
    }

    public LevenbergMarquardt(RegularizationMethod regularizationMethod, double[] initialParameters, double[] targetValues, int maxIteration, ExecutorService executorService) {
        this.regularizationMethod = regularizationMethod;
        this.initialParameters = initialParameters;
        this.targetValues = targetValues;
        this.maxIteration = maxIteration;
        this.weights = new double[targetValues.length];
        Arrays.fill(this.weights, 1.0);
        this.executor = executorService;
        this.executorShutdownWhenDone = executorService == null;
        this.numberOfThreads = 1;
    }

    public LevenbergMarquardt(double[] initialParameters, double[] targetValues, int maxIteration, ExecutorService executorService) {
        this(RegularizationMethod.LEVENBERG_MARQUARDT, initialParameters, targetValues, maxIteration, executorService);
    }

    public LevenbergMarquardt(RegularizationMethod regularizationMethod, double[] initialParameters, double[] targetValues, int maxIteration, int numberOfThreads) {
        this(regularizationMethod, initialParameters, targetValues, maxIteration, null);
        this.numberOfThreads = numberOfThreads;
    }

    public LevenbergMarquardt(double[] initialParameters, double[] targetValues, int maxIteration, int numberOfThreads) {
        this(RegularizationMethod.LEVENBERG_MARQUARDT, initialParameters, targetValues, maxIteration, numberOfThreads);
    }

    public LevenbergMarquardt(List<Number> initialParameters, List<Number> targetValues, int maxIteration, ExecutorService executorService) {
        this(LevenbergMarquardt.numberListToDoubleArray(initialParameters), LevenbergMarquardt.numberListToDoubleArray(targetValues), maxIteration, executorService);
    }

    public LevenbergMarquardt(List<Number> initialParameters, List<Number> targetValues, int maxIteration, int numberOfThreads) {
        this(initialParameters, targetValues, maxIteration, null);
        this.numberOfThreads = numberOfThreads;
    }

    public LevenbergMarquardt() {
        this.regularizationMethod = RegularizationMethod.LEVENBERG_MARQUARDT;
    }

    private static double[] numberListToDoubleArray(List<Number> listOfNumbers) {
        double[] arrayOfDoubles = new double[listOfNumbers.size()];
        for (int i = 0; i < arrayOfDoubles.length; ++i) {
            arrayOfDoubles[i] = listOfNumbers.get(i).doubleValue();
        }
        return arrayOfDoubles;
    }

    public LevenbergMarquardt(int numberOfThreads) {
        this.regularizationMethod = RegularizationMethod.LEVENBERG_MARQUARDT;
        this.numberOfThreads = numberOfThreads;
    }

    public LevenbergMarquardt setInitialParameters(double[] initialParameters) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.initialParameters = initialParameters;
        return this;
    }

    public LevenbergMarquardt setParameterSteps(double[] parameterSteps) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.parameterSteps = parameterSteps;
        return this;
    }

    public LevenbergMarquardt setTargetValues(double[] targetValues) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.targetValues = targetValues;
        return this;
    }

    public LevenbergMarquardt setMaxIteration(int maxIteration) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.maxIteration = maxIteration;
        return this;
    }

    public LevenbergMarquardt setWeights(double[] weights) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.weights = weights;
        return this;
    }

    public LevenbergMarquardt setErrorTolerance(double errorTolerance) {
        if (this.done()) {
            throw new UnsupportedOperationException("Solver cannot be modified after it has run.");
        }
        this.errorRootMeanSquaredTolerance = errorTolerance;
        return this;
    }

    public double getLambda() {
        return this.lambda;
    }

    public LevenbergMarquardt setLambda(double lambda) {
        this.lambda = lambda;
        return this;
    }

    public double getLambdaMultiplicator() {
        return this.lambdaMultiplicator;
    }

    public void setLambdaMultiplicator(double lambdaMultiplicator) {
        if (lambdaMultiplicator <= 1.0) {
            throw new IllegalArgumentException("Parameter lambdaMultiplicator is required to be > 1.");
        }
        this.lambdaMultiplicator = lambdaMultiplicator;
    }

    public double getLambdaDivisor() {
        return this.lambdaDivisor;
    }

    public void setLambdaDivisor(double lambdaDivisor) {
        if (lambdaDivisor <= 1.0) {
            throw new IllegalArgumentException("Parameter lambdaDivisor is required to be > 1.");
        }
        this.lambdaDivisor = lambdaDivisor;
    }

    @Override
    public double[] getBestFitParameters() {
        return this.parameterCurrent;
    }

    @Override
    public double getRootMeanSquaredError() {
        return Math.sqrt(this.errorMeanSquaredCurrent);
    }

    private void setErrorMeanSquaredCurrent(double errorMeanSquaredCurrent) {
        this.errorMeanSquaredCurrent = errorMeanSquaredCurrent;
    }

    @Override
    public int getIterations() {
        return this.iteration;
    }

    public abstract void setValues(double[] var1, double[] var2) throws SolverException;

    public void setDerivatives(double[] parameters, double[][] derivatives) throws SolverException {
        int parameterIndex;
        Vector<Future<double[]>> valueFutures = new Vector<Future<double[]>>(this.parameterCurrent.length);
        for (parameterIndex = 0; parameterIndex < this.parameterCurrent.length; ++parameterIndex) {
            final double[] parametersNew = (double[])parameters.clone();
            final double[] derivative = derivatives[parameterIndex];
            final int workerParameterIndex = parameterIndex;
            Callable<double[]> worker = new Callable<double[]>(){

                @Override
                public double[] call() {
                    double parameterFiniteDifference = LevenbergMarquardt.this.parameterSteps != null ? LevenbergMarquardt.this.parameterSteps[workerParameterIndex] : (Math.abs(parametersNew[workerParameterIndex]) + 1.0) * 1.0E-8;
                    int n = workerParameterIndex;
                    parametersNew[n] = parametersNew[n] + parameterFiniteDifference;
                    try {
                        LevenbergMarquardt.this.setValues(parametersNew, derivative);
                    }
                    catch (Exception e) {
                        Arrays.fill(derivative, Double.NaN);
                    }
                    for (int valueIndex = 0; valueIndex < LevenbergMarquardt.this.valueCurrent.length; ++valueIndex) {
                        int n2 = valueIndex;
                        derivative[n2] = derivative[n2] - LevenbergMarquardt.this.valueCurrent[valueIndex];
                        int n3 = valueIndex;
                        derivative[n3] = derivative[n3] / parameterFiniteDifference;
                        if (!Double.isNaN(derivative[valueIndex])) continue;
                        derivative[valueIndex] = 0.0;
                    }
                    return derivative;
                }
            };
            if (this.executor != null) {
                Future<double[]> valueFuture = this.executor.submit(worker);
                valueFutures.add(parameterIndex, valueFuture);
                continue;
            }
            FutureTask<double[]> valueFutureTask = new FutureTask<double[]>(worker);
            valueFutureTask.run();
            valueFutures.add(parameterIndex, valueFutureTask);
        }
        for (parameterIndex = 0; parameterIndex < this.parameterCurrent.length; ++parameterIndex) {
            try {
                derivatives[parameterIndex] = (double[])((Future)valueFutures.get(parameterIndex)).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SolverException(e);
            }
        }
    }

    boolean done() {
        return this.iteration > this.maxIteration || this.errorRootMeanSquaredChange <= this.errorRootMeanSquaredTolerance || Double.isInfinite(this.lambda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SolverException {
        if (this.numberOfThreads > 1 && this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.numberOfThreads);
            this.executorShutdownWhenDone = true;
        }
        try {
            int numberOfParameters = this.initialParameters.length;
            int numberOfValues = this.targetValues.length;
            this.parameterTest = (double[])this.initialParameters.clone();
            this.parameterIncrement = new double[numberOfParameters];
            this.parameterCurrent = new double[numberOfParameters];
            this.valueTest = new double[numberOfValues];
            this.valueCurrent = new double[numberOfValues];
            this.derivativeCurrent = new double[this.parameterCurrent.length][this.valueCurrent.length];
            this.hessianMatrix = new double[this.parameterCurrent.length][this.parameterCurrent.length];
            this.beta = new double[this.parameterCurrent.length];
            this.iteration = 0;
            while (true) {
                ++this.iteration;
                this.setValues(this.parameterTest, this.valueTest);
                double errorMeanSquaredTest = this.getMeanSquaredError(this.valueTest);
                if (errorMeanSquaredTest < this.errorMeanSquaredCurrent) {
                    this.errorRootMeanSquaredChange = Math.sqrt(this.errorMeanSquaredCurrent) - Math.sqrt(errorMeanSquaredTest);
                    System.arraycopy(this.parameterTest, 0, this.parameterCurrent, 0, this.parameterCurrent.length);
                    System.arraycopy(this.valueTest, 0, this.valueCurrent, 0, this.valueCurrent.length);
                    this.errorMeanSquaredCurrent = errorMeanSquaredTest;
                    this.isParameterCurrentDerivativeValid = false;
                    this.lambda /= this.lambdaDivisor;
                } else {
                    this.errorRootMeanSquaredChange = Math.sqrt(errorMeanSquaredTest) - Math.sqrt(this.errorMeanSquaredCurrent);
                    this.lambda *= this.lambdaMultiplicator;
                }
                if (!this.done()) {
                    this.updateParameterTest();
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    String logString = "Iteration: " + this.iteration + "\tLambda=" + this.lambda + "\tError Current (RMS):" + Math.sqrt(this.errorMeanSquaredCurrent) + "\tError Change:" + this.errorRootMeanSquaredChange + "\t";
                    for (int i = 0; i < this.parameterCurrent.length; ++i) {
                        logString = logString + "[" + i + "] = " + this.parameterCurrent[i] + "\t";
                    }
                    this.logger.fine(logString);
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.executor != null && this.executorShutdownWhenDone) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    public double getMeanSquaredError(double[] value) {
        double error = 0.0;
        for (int valueIndex = 0; valueIndex < value.length; ++valueIndex) {
            double deviation = value[valueIndex] - this.targetValues[valueIndex];
            error += this.weights[valueIndex] * deviation * deviation;
        }
        return error / (double)value.length;
    }

    private void updateParameterTest() throws SolverException {
        if (!this.isParameterCurrentDerivativeValid) {
            this.setDerivatives(this.parameterCurrent, this.derivativeCurrent);
            this.isParameterCurrentDerivativeValid = true;
        }
        boolean hessianInvalid = true;
        while (hessianInvalid) {
            int i;
            hessianInvalid = false;
            for (i = 0; i < this.parameterCurrent.length; ++i) {
                for (int j = i; j < this.parameterCurrent.length; ++j) {
                    double alphaElement = 0.0;
                    for (int valueIndex = 0; valueIndex < this.valueCurrent.length; ++valueIndex) {
                        alphaElement += this.weights[valueIndex] * this.derivativeCurrent[i][valueIndex] * this.derivativeCurrent[j][valueIndex];
                    }
                    if (i == j) {
                        alphaElement = this.regularizationMethod == RegularizationMethod.LEVENBERG ? (alphaElement += this.lambda) : (alphaElement == 0.0 ? this.lambda : (alphaElement *= 1.0 + this.lambda));
                    }
                    this.hessianMatrix[i][j] = alphaElement;
                    this.hessianMatrix[j][i] = alphaElement;
                }
            }
            for (i = 0; i < this.parameterCurrent.length; ++i) {
                double betaElement = 0.0;
                double[] derivativeCurrentSingleParam = this.derivativeCurrent[i];
                for (int k = 0; k < this.valueCurrent.length; ++k) {
                    betaElement += this.weights[k] * (this.targetValues[k] - this.valueCurrent[k]) * derivativeCurrentSingleParam[k];
                }
                this.beta[i] = betaElement;
            }
            try {
                this.parameterIncrement = LinearAlgebra.solveLinearEquationSymmetric(this.hessianMatrix, this.beta);
            }
            catch (Exception e) {
                hessianInvalid = true;
                this.lambda *= 16.0;
            }
        }
        for (int i = 0; i < this.parameterCurrent.length; ++i) {
            this.parameterTest[i] = this.parameterCurrent[i] + this.parameterIncrement[i];
        }
    }

    public LevenbergMarquardt clone() throws CloneNotSupportedException {
        LevenbergMarquardt clonedOptimizer = (LevenbergMarquardt)super.clone();
        clonedOptimizer.isParameterCurrentDerivativeValid = false;
        clonedOptimizer.iteration = 0;
        clonedOptimizer.errorMeanSquaredCurrent = Double.POSITIVE_INFINITY;
        clonedOptimizer.errorRootMeanSquaredChange = Double.POSITIVE_INFINITY;
        return clonedOptimizer;
    }

    public LevenbergMarquardt getCloneWithModifiedTargetValues(double[] newTargetVaues, double[] newWeights, boolean isUseBestParametersAsInitialParameters) throws CloneNotSupportedException {
        LevenbergMarquardt clonedOptimizer = this.clone();
        clonedOptimizer.targetValues = (double[])newTargetVaues.clone();
        clonedOptimizer.weights = (double[])newWeights.clone();
        if (isUseBestParametersAsInitialParameters && this.done()) {
            clonedOptimizer.initialParameters = this.getBestFitParameters();
        }
        return clonedOptimizer;
    }

    public LevenbergMarquardt getCloneWithModifiedTargetValues(List<Number> newTargetVaues, List<Number> newWeights, boolean isUseBestParametersAsInitialParameters) throws CloneNotSupportedException {
        LevenbergMarquardt clonedOptimizer = this.clone();
        clonedOptimizer.targetValues = LevenbergMarquardt.numberListToDoubleArray(newTargetVaues);
        clonedOptimizer.weights = LevenbergMarquardt.numberListToDoubleArray(newWeights);
        if (isUseBestParametersAsInitialParameters && this.done()) {
            clonedOptimizer.initialParameters = this.getBestFitParameters();
        }
        return clonedOptimizer;
    }

    public static enum RegularizationMethod {
        LEVENBERG,
        LEVENBERG_MARQUARDT;

    }
}

