/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;

public class CSVCurveParser {
    private CurveInterpolation.InterpolationMethod interpolationMethod;
    private CurveInterpolation.ExtrapolationMethod extrapolationMethod;
    private CurveInterpolation.InterpolationEntity interpolationEntity;

    public CSVCurveParser() {
        this(CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
    }

    public CSVCurveParser(CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
    }

    public DiscountCurve parseCSV(File file, String currency, String index) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        DiscountCurve curve = this.parseStream(stream, currency, index);
        ((InputStream)stream).close();
        return curve;
    }

    public DiscountCurve[] parseZIP(File file, String currency, String index) throws IOException {
        ArrayList<DiscountCurve> curves = new ArrayList<DiscountCurve>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                InputStream inputStream = zip.getInputStream(entries.nextElement());
                try {
                    curves.add(this.parseStream(inputStream, currency, index));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return curves.toArray(new DiscountCurve[curves.size()]);
    }

    public void setInterpolation(CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
    }

    public static LocalDate[] getReferenceDates(Curve[] curves) {
        return (LocalDate[])Arrays.stream(curves).map(Curve::getReferenceDate).toArray(LocalDate[]::new);
    }

    private DiscountCurve parseStream(InputStream stream, String currency, String index) throws IOException {
        String line;
        System.out.println("Currency " + currency + "Index " + index);
        ArrayList<Double> times = new ArrayList<Double>();
        ArrayList<Double> rates = new ArrayList<Double>();
        String csvSplitBy = ";";
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        CSVCurveParser.readNonEmptyLine(reader);
        CSVCurveParser.readNonEmptyLine(reader);
        LocalDate referenceDate = LocalDate.parse(CSVCurveParser.readNonEmptyLine(reader).replaceFirst("\\D+", ""), DateTimeFormatter.ofPattern("d/MM/yy"));
        while ((line = CSVCurveParser.readNonEmptyLine(reader)) != null) {
            String[] inputs = line.split(";");
            if (!inputs[0].equalsIgnoreCase(currency) || !inputs[1].equalsIgnoreCase(index)) continue;
            times.add(Double.parseDouble(inputs[4]) / 365.0);
            rates.add(Double.parseDouble(inputs[5]) / 100.0);
        }
        reader.close();
        return DiscountCurveInterpolation.createDiscountCurveFromZeroRates(currency + "_" + index, referenceDate, times.stream().mapToDouble(Double::doubleValue).toArray(), rates.stream().mapToDouble(Double::doubleValue).toArray(), this.interpolationMethod, this.extrapolationMethod, this.interpolationEntity);
    }

    private static String readNonEmptyLine(BufferedReader reader) throws IOException {
        String line = "";
        while (line.equals("")) {
            line = reader.readLine();
            if (line != null) continue;
            return null;
        }
        return line;
    }
}

