/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.time.SchedulePrototype;

public class CSVSwaptionParser {
    private double fileQuotingUnit = 0.01;
    private double fileQuotingUnitForDisplacement = 0.01;
    private SwaptionDataLattice.QuotingConvention fileQuotingConvention = SwaptionDataLattice.QuotingConvention.PAYERVOLATILITYLOGNORMAL;
    private final String swaptionCode = "SWOPT";
    private final String csvSplitBy = ";";
    private final Set<String> maturities;
    private final Set<String> tenors;
    private final SchedulePrototype fixMetaSchedule;
    private final SchedulePrototype floatMetaSchedule;

    public CSVSwaptionParser(SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule) {
        this.maturities = Collections.emptySet();
        this.tenors = Collections.emptySet();
        this.fixMetaSchedule = fixMetaSchedule;
        this.floatMetaSchedule = floatMetaSchedule;
    }

    public CSVSwaptionParser(String[] maturities, String[] tenors, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule) {
        this.maturities = Arrays.stream(maturities).map(String::toUpperCase).collect(Collectors.toCollection(HashSet::new));
        this.tenors = Arrays.stream(tenors).map(String::toUpperCase).collect(Collectors.toCollection(HashSet::new));
        this.fixMetaSchedule = fixMetaSchedule;
        this.floatMetaSchedule = floatMetaSchedule;
    }

    public void setFileQuotingConvention(SwaptionDataLattice.QuotingConvention fileQuotingConvention, double fileQuotingUnit, double fileQuotingUnitForDisplacement) {
        this.fileQuotingConvention = fileQuotingConvention;
        this.fileQuotingUnit = fileQuotingUnit;
        this.fileQuotingUnitForDisplacement = fileQuotingUnitForDisplacement;
    }

    public SwaptionDataLattice parseCSV(File atmFile, File otmFile, LocalDate referenceDate, String currency, String index, String discountCurveName) throws IOException {
        FileInputStream atmStream = new FileInputStream(atmFile);
        FileInputStream otmStream = new FileInputStream(otmFile);
        SwaptionDataLattice data = this.parseStreams(atmStream, otmStream, referenceDate, currency, index, discountCurveName);
        ((InputStream)atmStream).close();
        ((InputStream)otmStream).close();
        return data;
    }

    public SwaptionDataLattice[] parseZIP(File atmFile, File otmFile, String currency, String index, String discountCurveName) throws IOException {
        ZipFile atmZip = new ZipFile(atmFile);
        ZipFile otmZip = new ZipFile(otmFile);
        ArrayList<SwaptionDataLattice> lattices = new ArrayList<SwaptionDataLattice>();
        Enumeration<? extends ZipEntry> atmEntries = atmZip.entries();
        Enumeration<? extends ZipEntry> otmEntries = otmZip.entries();
        while (atmEntries.hasMoreElements() && otmEntries.hasMoreElements()) {
            ZipEntry atmEntry = atmEntries.nextElement();
            ZipEntry otmEntry = otmEntries.nextElement();
            LocalDate referenceDate = LocalDate.parse(atmEntry.getName().replaceAll("\\D", ""), DateTimeFormatter.ofPattern("yyyyMMdd"));
            if (!referenceDate.equals(LocalDate.parse(otmEntry.getName().replaceAll("\\D", ""), DateTimeFormatter.ofPattern("yyyyMMdd")))) {
                atmZip.close();
                otmZip.close();
                throw new IllegalArgumentException("Files in zip archive not aligned for reference date.");
            }
            InputStream atmStream = atmZip.getInputStream(atmEntry);
            try {
                InputStream otmStream = otmZip.getInputStream(otmEntry);
                try {
                    lattices.add(this.parseStreams(atmStream, otmStream, referenceDate, currency, index, discountCurveName));
                }
                finally {
                    if (otmStream == null) continue;
                    otmStream.close();
                }
            }
            finally {
                if (atmStream == null) continue;
                atmStream.close();
            }
        }
        atmZip.close();
        otmZip.close();
        return lattices.toArray(new SwaptionDataLattice[0]);
    }

    private SwaptionDataLattice parseStreams(InputStream atmStream, InputStream otmStream, LocalDate referenceDate, String currency, String index, String discountCurveName) throws IOException {
        String[] inputs;
        String line;
        BufferedReader atmReader = new BufferedReader(new InputStreamReader(atmStream));
        BufferedReader otmReader = new BufferedReader(new InputStreamReader(otmStream));
        double shift = 0.0;
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<Integer> moneynesss = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        int i = -1;
        while ((line = atmReader.readLine()) != null) {
            ++i;
            inputs = line.split(";");
            String maturity = inputs[4].toUpperCase();
            String tenor = inputs[3].toUpperCase();
            if (!inputs[0].equalsIgnoreCase(currency) || !inputs[2].split("_")[0].equalsIgnoreCase("SWOPT") || !this.maturities.isEmpty() && !this.maturities.contains(maturity) || !this.tenors.isEmpty() && !this.tenors.contains(tenor)) continue;
            if (inputs[1].equalsIgnoreCase("SHIFT")) {
                if (shift == 0.0) {
                    shift = Double.parseDouble(inputs[5]) * this.fileQuotingUnitForDisplacement;
                    continue;
                }
                if (shift != Double.parseDouble(inputs[5]) * this.fileQuotingUnitForDisplacement) {
                    System.out.println(i);
                    System.out.println(line);
                    throw new IllegalArgumentException("Shift not alligned for all filtered tenors at reference date " + referenceDate + ".");
                }
            }
            if (!inputs[1].equalsIgnoreCase(index)) continue;
            codes.add(maturity + tenor);
            moneynesss.add(0);
            values.add(Double.parseDouble(inputs[5]) * this.fileQuotingUnit);
        }
        while ((line = otmReader.readLine()) != null) {
            String[] tokens;
            inputs = line.split(";");
            if (inputs.length < 10 || (tokens = inputs[3].split("/")).length < 8 || tokens[7].equalsIgnoreCase("P")) continue;
            String maturity = inputs[8].toUpperCase();
            String tenor = tokens[6].toUpperCase();
            int moneyness = (int)Double.parseDouble(inputs[4]);
            if (!tokens[1].equalsIgnoreCase(currency) || !tokens[2].equalsIgnoreCase(index) || !tokens[3].equalsIgnoreCase("SWOPT") || moneyness == 0 || this.maturities != null && !this.maturities.contains(maturity) || this.tenors != null && this.tenors.contains(tenor)) continue;
            codes.add(maturity + tenor);
            moneynesss.add(moneyness);
            values.add(Double.parseDouble(inputs[9]) * this.fileQuotingUnit);
        }
        return new SwaptionDataLattice(referenceDate, this.fileQuotingConvention, shift, "Forward_" + currency + "_" + index, discountCurveName, this.floatMetaSchedule, this.fixMetaSchedule, codes.toArray(new String[0]), moneynesss.stream().mapToInt(Integer::intValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public SwaptionDataLattice[] parseZIPToConvention(File atmFile, File otmFile, String currency, String index, String discountCurveName, SwaptionDataLattice.QuotingConvention convention, double displacement, AnalyticModel ... models) throws IOException {
        HashMap<LocalDate, AnalyticModel> modelMap = new HashMap<LocalDate, AnalyticModel>();
        for (AnalyticModel model : models) {
            if (((AnalyticModelFromCurvesAndVols)model).getReferenceDate() == null) {
                throw new IllegalArgumentException("No reference date assigned to " + model.toString());
            }
            modelMap.put(((AnalyticModelFromCurvesAndVols)model).getReferenceDate(), model);
        }
        ZipFile atmZip = new ZipFile(atmFile);
        ZipFile otmZip = new ZipFile(otmFile);
        ArrayList<SwaptionDataLattice> lattices = new ArrayList<SwaptionDataLattice>();
        Enumeration<? extends ZipEntry> atmEntries = atmZip.entries();
        Enumeration<? extends ZipEntry> otmEntries = otmZip.entries();
        while (atmEntries.hasMoreElements() && otmEntries.hasMoreElements()) {
            ZipEntry atmEntry = atmEntries.nextElement();
            ZipEntry otmEntry = otmEntries.nextElement();
            LocalDate referenceDate = LocalDate.parse(atmEntry.getName().replaceAll("\\D", ""), DateTimeFormatter.ofPattern("yyyyMMdd"));
            if (!referenceDate.equals(LocalDate.parse(otmEntry.getName().replaceAll("\\D", ""), DateTimeFormatter.ofPattern("yyyyMMdd")))) {
                atmZip.close();
                otmZip.close();
                throw new IllegalArgumentException("Files in zip archive not aligned for reference date.");
            }
            if (!modelMap.containsKey(referenceDate)) continue;
            lattices.add(this.parseStreamsToConvention(atmZip, atmEntry, otmZip, otmEntry, referenceDate, currency, index, discountCurveName, convention, displacement, (AnalyticModel)modelMap.get(referenceDate)));
        }
        atmZip.close();
        otmZip.close();
        return lattices.toArray(new SwaptionDataLattice[0]);
    }

    private SwaptionDataLattice parseStreamsToConvention(ZipFile atmZip, ZipEntry atmEntry, ZipFile otmZip, ZipEntry otmEntry, LocalDate referenceDate, String currency, String index, String discountCurveName, SwaptionDataLattice.QuotingConvention convention, double displacement, AnalyticModel model) throws IOException {
        SwaptionDataLattice data = new SwaptionDataLattice(referenceDate, convention, displacement, "Forward_" + currency + "_" + index, discountCurveName, this.floatMetaSchedule, this.fixMetaSchedule, new String[0], new int[0], new double[0]);
        for (String maturity : this.maturities) {
            for (String tenor : this.tenors) {
                CSVSwaptionParser partialParser = new CSVSwaptionParser(new String[]{maturity}, new String[]{tenor}, this.fixMetaSchedule, this.floatMetaSchedule);
                InputStream atmStream = atmZip.getInputStream(atmEntry);
                try {
                    InputStream otmStream = otmZip.getInputStream(otmEntry);
                    try {
                        data = data.append(partialParser.parseStreams(atmStream, otmStream, referenceDate, currency, index, discountCurveName), model);
                    }
                    finally {
                        if (otmStream == null) continue;
                        otmStream.close();
                    }
                }
                finally {
                    if (atmStream == null) continue;
                    atmStream.close();
                }
            }
        }
        return data;
    }

    public Set<SwaptionDataLattice> parseCSVMultiShift(File atmFile, File otmFile, LocalDate referenceDate, String currency, String index, String discountCurveName) throws IOException {
        HashSet<SwaptionDataLattice> lattices = new HashSet<SwaptionDataLattice>();
        Map<Double, Set<String>> tenorMap = this.parseTenorsPerShift(atmFile, currency);
        for (Set<String> tenors : tenorMap.values()) {
            CSVSwaptionParser partialParser = new CSVSwaptionParser(this.maturities.toArray(new String[0]), tenors.toArray(new String[0]), this.fixMetaSchedule, this.floatMetaSchedule);
            lattices.add(partialParser.parseCSV(atmFile, otmFile, referenceDate, currency, index, discountCurveName));
        }
        return lattices;
    }

    public Map<Double, Set<String>> parseTenorsPerShift(File atmFile, String currency) throws IOException {
        String line;
        BufferedReader atmReader = new BufferedReader(new FileReader(atmFile));
        HashMap map = new HashMap();
        while ((line = atmReader.readLine()) != null) {
            String[] inputs = line.split(";");
            String maturity = inputs[4].toUpperCase();
            String tenor = inputs[3].toUpperCase();
            if (!inputs[0].equalsIgnoreCase(currency) || !inputs[2].split("_")[0].equalsIgnoreCase("SWOPT") || !this.maturities.isEmpty() && !this.maturities.contains(maturity) || !this.tenors.isEmpty() && !this.tenors.contains(tenor) || !inputs[1].equalsIgnoreCase("SHIFT")) continue;
            double shift = Double.parseDouble(inputs[5]) * this.fileQuotingUnitForDisplacement;
            if (!map.containsKey(shift)) {
                map.put(shift, new HashSet());
            }
            ((Set)map.get(shift)).add(tenor);
        }
        atmReader.close();
        return Collections.unmodifiableMap(map);
    }

    public static LocalDate[] getReferenceDates(SwaptionDataLattice[] lattices) {
        return (LocalDate[])Arrays.stream(lattices).map(SwaptionDataLattice::getReferenceDate).toArray(LocalDate[]::new);
    }
}

