/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.randomnumbers;

import java.util.concurrent.atomic.AtomicInteger;
import net.finmath.randomnumbers.RandomNumberGenerator1D;
import org.apache.commons.lang3.Validate;

public class VanDerCorputSequence
implements RandomNumberGenerator1D {
    private static final long serialVersionUID = 1368710922067034251L;
    private final AtomicInteger index;
    private final int base;

    public static void main(String[] args) {
        for (int i = 0; i < 30; ++i) {
            double x = VanDerCorputSequence.getVanDerCorputNumber(i, 2);
            System.out.println(i + "\t" + x);
        }
    }

    public VanDerCorputSequence(int startIndex, int base) {
        Validate.isTrue((startIndex >= 0 ? 1 : 0) != 0, (String)"Parameter base startIndex be >= 0.", (Object[])new Object[0]);
        Validate.isTrue((base > 1 ? 1 : 0) != 0, (String)"Parameter base must be > 1.", (Object[])new Object[0]);
        this.index = new AtomicInteger(startIndex);
        this.base = base;
    }

    public VanDerCorputSequence(int base) {
        this(0, base);
    }

    @Override
    public double nextDouble() {
        return VanDerCorputSequence.getVanDerCorputNumber(this.index.getAndIncrement(), this.base);
    }

    public static double getVanDerCorputNumber(long index, int base) {
        ++index;
        double x = 0.0;
        double refinementFactor = 1.0 / (double)base;
        while (index > 0L) {
            x += (double)(index % (long)base) * refinementFactor;
            index /= (long)base;
            refinementFactor /= (double)base;
        }
        return x;
    }
}

