/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.annuitymapping;

import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.BasicPiterbargAnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.MultiPiterbargAnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.SimplifiedLinearAnnuityMapping;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public class AnnuityMappingFactory {
    private final Schedule fixSchedule;
    private final Schedule floatSchedule;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final String volatilityCubeName;
    private final double strike;
    private final double lowerBound;
    private final double upperBound;
    private final int numberOfEvaluationPoints;

    public static AnnuityMapping buildAnnuityMapping(double strike, Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType type, VolatilityCubeModel model) {
        AnnuityMappingFactory factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName, strike, 0.0, 0.0, -1);
        return factory.build(type, model);
    }

    public static AnnuityMapping buildAnnuityMapping(double strike, Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType type, VolatilityCubeModel model, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        AnnuityMappingFactory factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName, strike, lowerBound, upperBound, numberOfEvaluationPoints);
        return factory.build(type, model);
    }

    public AnnuityMappingFactory(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName) {
        this(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName, Double.NaN, 0.0, 0.0, -1);
    }

    public AnnuityMappingFactory(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, double strike, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.fixSchedule = fixSchedule;
        this.floatSchedule = floatSchedule;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.volatilityCubeName = volatilityCubeName;
        this.strike = strike;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public AnnuityMapping build(AnnuityMapping.AnnuityMappingType type, VolatilityCubeModel model) {
        AnnuityMapping annuityMapping;
        double strike = this.strike;
        if (Double.isNaN(strike)) {
            ForwardCurve forwardCurve = this.forwardCurveName == null || this.forwardCurveName.isEmpty() ? new ForwardCurveFromDiscountCurve(this.discountCurveName, this.fixSchedule.getReferenceDate(), SchedulePrototype.getOffsetCodeFromSchedule(this.fixSchedule)) : model.getForwardCurve(this.forwardCurveName);
            strike = Swap.getForwardSwapRate(this.fixSchedule, this.floatSchedule, forwardCurve, model);
        }
        switch (type) {
            case MULTIPITERBARG: {
                annuityMapping = new MultiPiterbargAnnuityMapping(this.fixSchedule, this.floatSchedule, strike, model, this.discountCurveName, this.forwardCurveName, this.volatilityCubeName, this.lowerBound, this.upperBound, this.numberOfEvaluationPoints);
                break;
            }
            case BASICPITERBARG: {
                annuityMapping = new BasicPiterbargAnnuityMapping(this.fixSchedule, this.floatSchedule, strike, model, this.discountCurveName, this.volatilityCubeName, this.lowerBound, this.upperBound, this.numberOfEvaluationPoints);
                break;
            }
            case SIMPLIFIEDLINEAR: {
                annuityMapping = new SimplifiedLinearAnnuityMapping(this.fixSchedule, this.floatSchedule, model, this.discountCurveName);
                break;
            }
            default: {
                annuityMapping = new BasicPiterbargAnnuityMapping(this.fixSchedule, this.floatSchedule, strike, model, this.discountCurveName, this.volatilityCubeName, 0.0, 0.0, -1);
            }
        }
        return annuityMapping;
    }
}

