/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.calibration;

import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.marketdata.products.Swap;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.AnnuityMappingFactory;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;
import net.finmath.singleswaprate.products.AbstractSingleSwapRateProduct;
import net.finmath.singleswaprate.products.CashSettledPayerSwaption;
import net.finmath.singleswaprate.products.CashSettledReceiverSwaption;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public abstract class AbstractCubeCalibration {
    private final LocalDate referenceDate;
    private final SwaptionDataLattice cashPayerPremiums;
    private final SwaptionDataLattice cashReceiverPremiums;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final VolatilityCubeModel model;
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;
    private int maxIterations = 250;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private boolean replicationUseAsOffset = true;
    private double replicationLowerBound = -0.15;
    private double replicationUpperBound = 0.15;
    private int replicationNumberOfEvaluationPoints = 500;
    private double[] initialParameters;
    private double[] calibratedParameters;
    private double[] marketTargets;
    private final ArrayList<SwaptionInfo> payerSwaptions = new ArrayList();
    private final ArrayList<SwaptionInfo> receiverSwaptions = new ArrayList();

    public AbstractCubeCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        if (cashPayerPremiums.getQuotingConvention() != SwaptionDataLattice.QuotingConvention.PAYERPRICE || cashReceiverPremiums.getQuotingConvention() != SwaptionDataLattice.QuotingConvention.RECEIVERPRICE) {
            throw new IllegalArgumentException("Swaption data not provided in QuotingConvention.PAYERPRICE and QuotingConvention.RECEIVERPRICE respectively.");
        }
        this.referenceDate = referenceDate;
        this.cashPayerPremiums = cashPayerPremiums;
        this.cashReceiverPremiums = cashReceiverPremiums;
        this.model = model;
        this.annuityMappingType = annuityMappingType;
        this.discountCurveName = cashPayerPremiums.getDiscountCurveName();
        this.forwardCurveName = cashPayerPremiums.getForwardCurveName();
    }

    protected abstract VolatilityCube buildCube(String var1, double[] var2);

    protected abstract void initializeParameters();

    protected abstract double[] applyParameterBounds(double[] var1);

    public VolatilityCube calibrate(String cubeName) throws SolverException {
        this.generateTargets();
        this.initializeParameters();
        this.runOptimization();
        return this.buildCube(cubeName, this.calibratedParameters);
    }

    private void runOptimization() throws SolverException {
        LevenbergMarquardt optimizer = new LevenbergMarquardt(this.getInitialParameters(), this.marketTargets, this.maxIterations, this.numberOfThreads){
            private static final long serialVersionUID = -7604474677930060206L;

            @Override
            public void setValues(double[] parameters, double[] values) {
                AbstractSingleSwapRateProduct css;
                AnnuityMappingFactory factory;
                AnnuityMapping mapping;
                String mappingName;
                double replicationUpperBound;
                double replicationLowerBound;
                double strike;
                double forwardSwapRate;
                Schedule floatSchedule;
                Schedule fixSchedule;
                parameters = AbstractCubeCalibration.this.applyParameterBounds(parameters);
                String tempCubeName = "tempCube";
                VolatilityCube cube = AbstractCubeCalibration.this.buildCube("tempCube", parameters);
                VolatilityCubeModel tempModel = AbstractCubeCalibration.this.getModel().addVolatilityCube(cube);
                HashMap<String, AnnuityMapping> container = new HashMap<String, AnnuityMapping>();
                int index = 0;
                SchedulePrototype fixMetaSchedule = AbstractCubeCalibration.this.cashPayerPremiums.getFixMetaSchedule();
                SchedulePrototype floatMetaSchedule = AbstractCubeCalibration.this.cashPayerPremiums.getFloatMetaSchedule();
                for (SwaptionInfo swaption : AbstractCubeCalibration.this.payerSwaptions) {
                    fixSchedule = fixMetaSchedule.generateSchedule(AbstractCubeCalibration.this.getReferenceDate(), swaption.maturity, swaption.termination);
                    floatSchedule = floatMetaSchedule.generateSchedule(AbstractCubeCalibration.this.getReferenceDate(), swaption.maturity, swaption.termination);
                    forwardSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, tempModel.getForwardCurve(AbstractCubeCalibration.this.getForwardCurveName()), tempModel);
                    strike = forwardSwapRate + swaption.moneyness;
                    replicationLowerBound = AbstractCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + AbstractCubeCalibration.this.replicationLowerBound : AbstractCubeCalibration.this.replicationLowerBound;
                    replicationUpperBound = AbstractCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + AbstractCubeCalibration.this.replicationUpperBound : AbstractCubeCalibration.this.replicationUpperBound;
                    mappingName = swaption.toString();
                    if (container.containsKey(mappingName)) {
                        mapping = (AnnuityMapping)container.get(mappingName);
                    } else {
                        factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, AbstractCubeCalibration.this.discountCurveName, AbstractCubeCalibration.this.getForwardCurveName(), "tempCube", strike, replicationLowerBound, replicationUpperBound, AbstractCubeCalibration.this.replicationNumberOfEvaluationPoints);
                        mapping = factory.build(AbstractCubeCalibration.this.annuityMappingType, tempModel);
                        container.put(mappingName, mapping);
                    }
                    css = new CashSettledPayerSwaption(fixSchedule, floatSchedule, strike, AbstractCubeCalibration.this.discountCurveName, AbstractCubeCalibration.this.getForwardCurveName(), "tempCube", AbstractCubeCalibration.this.annuityMappingType, replicationLowerBound, replicationUpperBound, AbstractCubeCalibration.this.replicationNumberOfEvaluationPoints);
                    values[index++] = css.getValue(floatSchedule.getFixing(0), mapping, tempModel);
                }
                fixMetaSchedule = AbstractCubeCalibration.this.cashReceiverPremiums.getFixMetaSchedule();
                floatMetaSchedule = AbstractCubeCalibration.this.cashReceiverPremiums.getFloatMetaSchedule();
                for (SwaptionInfo swaption : AbstractCubeCalibration.this.receiverSwaptions) {
                    fixSchedule = fixMetaSchedule.generateSchedule(AbstractCubeCalibration.this.getReferenceDate(), swaption.maturity, swaption.termination);
                    floatSchedule = floatMetaSchedule.generateSchedule(AbstractCubeCalibration.this.getReferenceDate(), swaption.maturity, swaption.termination);
                    forwardSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, tempModel.getForwardCurve(AbstractCubeCalibration.this.getForwardCurveName()), tempModel);
                    strike = forwardSwapRate + swaption.moneyness;
                    replicationLowerBound = AbstractCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + AbstractCubeCalibration.this.replicationLowerBound : AbstractCubeCalibration.this.replicationLowerBound;
                    replicationUpperBound = AbstractCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + AbstractCubeCalibration.this.replicationUpperBound : AbstractCubeCalibration.this.replicationUpperBound;
                    mappingName = swaption.toString();
                    if (container.containsKey(mappingName)) {
                        mapping = (AnnuityMapping)container.get(mappingName);
                    } else {
                        factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, AbstractCubeCalibration.this.discountCurveName, AbstractCubeCalibration.this.getForwardCurveName(), "tempCube", strike, replicationLowerBound, replicationUpperBound, AbstractCubeCalibration.this.replicationNumberOfEvaluationPoints);
                        mapping = factory.build(AbstractCubeCalibration.this.annuityMappingType, tempModel);
                        container.put(mappingName, mapping);
                    }
                    css = new CashSettledReceiverSwaption(fixSchedule, floatSchedule, strike, AbstractCubeCalibration.this.discountCurveName, AbstractCubeCalibration.this.getForwardCurveName(), "tempCube", AbstractCubeCalibration.this.annuityMappingType, replicationLowerBound, replicationUpperBound, AbstractCubeCalibration.this.replicationNumberOfEvaluationPoints);
                    values[index++] = css.getValue(floatSchedule.getFixing(0), mapping, tempModel);
                }
            }
        };
        optimizer.run();
        System.out.println("Optimizer finished after " + optimizer.getIterations() + " iterations with mean error " + optimizer.getRootMeanSquaredError());
        this.calibratedParameters = this.applyParameterBounds(optimizer.getBestFitParameters());
    }

    private void generateTargets() {
        ArrayList<Double> targetsPayer = new ArrayList<Double>();
        ArrayList<Double> targetsReceiver = new ArrayList<Double>();
        for (int moneyness : this.cashPayerPremiums.getMoneyness()) {
            for (int maturity : this.cashPayerPremiums.getMaturities(moneyness)) {
                for (int termination : this.cashPayerPremiums.getTenors(moneyness, maturity)) {
                    targetsPayer.add(this.cashPayerPremiums.getValue(maturity, termination, moneyness));
                    this.payerSwaptions.add(new SwaptionInfo(moneyness, maturity, termination));
                }
            }
        }
        for (int moneyness : this.cashReceiverPremiums.getMoneyness()) {
            for (int maturity : this.cashReceiverPremiums.getMaturities(moneyness)) {
                for (int termination : this.cashReceiverPremiums.getTenors(moneyness, maturity)) {
                    targetsReceiver.add(this.cashReceiverPremiums.getValue(maturity, termination, moneyness));
                    this.receiverSwaptions.add(new SwaptionInfo(-moneyness, maturity, termination));
                }
            }
        }
        this.marketTargets = Stream.concat(targetsPayer.stream(), targetsReceiver.stream()).mapToDouble(Double::doubleValue).toArray();
    }

    public void setCalibrationParameters(int maxIterations, int numberOfThreads) {
        this.maxIterations = maxIterations;
        this.numberOfThreads = numberOfThreads;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setReplicationParameters(boolean useAsOffset, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.replicationUseAsOffset = useAsOffset;
        this.replicationLowerBound = lowerBound;
        this.replicationUpperBound = upperBound;
        this.replicationNumberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public boolean isReplicationUseAsOffset() {
        return this.replicationUseAsOffset;
    }

    public double getReplicationLowerBound() {
        return this.replicationLowerBound;
    }

    public double getReplicationUpperBound() {
        return this.replicationUpperBound;
    }

    public int getReplicationNumberOfEvaluationPoints() {
        return this.replicationNumberOfEvaluationPoints;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public VolatilityCubeModel getModel() {
        return this.model;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double[] getInitialParameters() {
        return this.initialParameters;
    }

    public void setInitialParameters(double[] initialParameters) {
        this.initialParameters = initialParameters;
    }

    protected class SwaptionInfo {
        private final double moneyness;
        private final LocalDate maturity;
        private final LocalDate termination;

        SwaptionInfo(int moneyness, int maturity, int termination) {
            this.moneyness = (double)moneyness / 10000.0;
            this.maturity = AbstractCubeCalibration.this.getReferenceDate().plusMonths(maturity);
            this.termination = this.maturity.plusMonths(termination);
        }

        SwaptionInfo(int moneyness, int maturity, int termination, DataTable.TableConvention tableConvention) throws IOException {
            this.moneyness = (double)moneyness / 10000.0;
            switch (tableConvention) {
                case MONTHS: {
                    this.maturity = AbstractCubeCalibration.this.getReferenceDate().plusMonths(maturity);
                    this.termination = this.maturity.plusMonths(termination);
                    break;
                }
                case YEARS: {
                    this.maturity = AbstractCubeCalibration.this.getReferenceDate().plusYears(maturity);
                    this.termination = this.maturity.plusYears(termination);
                    break;
                }
                case DAYS: {
                    this.maturity = AbstractCubeCalibration.this.getReferenceDate().plusDays(maturity);
                    this.termination = this.maturity.plusDays(termination);
                    break;
                }
                case WEEKS: {
                    this.maturity = AbstractCubeCalibration.this.getReferenceDate().plusDays(maturity * 7);
                    this.termination = this.maturity.plusDays(termination * 7);
                    break;
                }
                default: {
                    throw new IOException("TableConvention " + (Object)((Object)tableConvention) + " not recognized.");
                }
            }
        }

        public String toString() {
            return this.moneyness + "/" + this.maturity + "/" + this.termination;
        }
    }
}

