/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.calibration;

import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.marketdata.products.Swap;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.AnnuityMappingFactory;
import net.finmath.singleswaprate.calibration.SABRShiftedSmileCalibration;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableBasic;
import net.finmath.singleswaprate.data.DataTableInterpolated;
import net.finmath.singleswaprate.data.DataTableLight;
import net.finmath.singleswaprate.data.DataTableLinear;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCube;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;
import net.finmath.singleswaprate.products.AbstractSingleSwapRateProduct;
import net.finmath.singleswaprate.products.CashSettledPayerSwaption;
import net.finmath.singleswaprate.products.CashSettledReceiverSwaption;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;
import org.apache.commons.lang3.ArrayUtils;

public class SABRCubeCalibration {
    private final LocalDate referenceDate;
    private final SwaptionDataLattice cashPayerPremiums;
    private final SwaptionDataLattice cashReceiverPremiums;
    private final SwaptionDataLattice physicalPremiumsATM;
    private final SchedulePrototype tableMetaSchedule;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final VolatilityCubeModel model;
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;
    private boolean useLinearInterpolation = true;
    private int maxIterations = 250;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private boolean replicationUseAsOffset = true;
    private double replicationLowerBound = -0.15;
    private double replicationUpperBound = 0.15;
    private int replicationNumberOfEvaluationPoints = 500;
    private double correlationDecay = 0.045;
    private double iborOisDecorrelation = 1.2;
    private double displacement = 0.15;
    private double beta = 0.5;
    private DataTable swapRateTable;
    private DataTable initialRhos = null;
    private DataTable initialBaseVols = null;
    private DataTable initialVolvols = null;
    private int[] terminations;
    private double[] parameters;
    private double[] marketTargets;
    private ArrayList<SwaptionInfo> payerSwaptions;
    private ArrayList<SwaptionInfo> receiverSwaptions;
    private int currentMaturity;
    private DataTable rhoTable;
    private DataTable baseVolTable;
    private DataTable volvolTable;

    public SABRCubeCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, SwaptionDataLattice physicalPremiumsATM, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        if (cashPayerPremiums.getQuotingConvention() != SwaptionDataLattice.QuotingConvention.PAYERPRICE || cashReceiverPremiums.getQuotingConvention() != SwaptionDataLattice.QuotingConvention.RECEIVERPRICE) {
            throw new IllegalArgumentException("Swaption data not provided in QuotingConvention.PAYERPRICE or QuotingConvention.RECEIVERPRICE respectively.");
        }
        this.referenceDate = referenceDate;
        this.physicalPremiumsATM = physicalPremiumsATM;
        this.cashPayerPremiums = cashPayerPremiums;
        this.cashReceiverPremiums = cashReceiverPremiums;
        this.model = model;
        this.annuityMappingType = annuityMappingType;
        this.tableMetaSchedule = physicalPremiumsATM.getFloatMetaSchedule();
        this.discountCurveName = cashPayerPremiums.getDiscountCurveName();
        this.forwardCurveName = cashPayerPremiums.getForwardCurveName();
    }

    public SABRCubeCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, SwaptionDataLattice physicalPremiumsATM, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType, double sabrDisplacement, double sabrBeta, double correlationDecay, double iborOisDecorrelation) {
        this(referenceDate, cashPayerPremiums, cashReceiverPremiums, physicalPremiumsATM, model, annuityMappingType);
        this.displacement = sabrDisplacement;
        this.beta = sabrBeta;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    public SABRVolatilityCube calibrate(String cubeName, int[] terminations) throws SolverException {
        DataTableLight nodes = this.findInterpolationNodes();
        this.terminations = terminations;
        if (this.useLinearInterpolation) {
            this.rhoTable = new DataTableLinear("Calibrated Rhos", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
            this.baseVolTable = new DataTableLinear("Calibrated baseVols", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
            this.volvolTable = new DataTableLinear("Calibrated volVols", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
        } else {
            this.rhoTable = new DataTableInterpolated("Calibrated Rhos", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
            this.baseVolTable = new DataTableInterpolated("Calibrated baseVols", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
            this.volvolTable = new DataTableInterpolated("Calibrated volVols", nodes.getConvention(), this.referenceDate, this.tableMetaSchedule);
        }
        Integer[] maturities = nodes.getMaturities().toArray(new Integer[0]);
        Arrays.sort(maturities, Collections.reverseOrder());
        this.findInitialParameters();
        Integer[] integerArray = maturities;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int maturity = integerArray[i];
            this.initializeParameters(maturity);
            this.generateTargets(maturity);
            this.currentMaturity = maturity;
            this.runOptimization();
            this.gatherParameters();
        }
        return new SABRVolatilityCube(cubeName, this.referenceDate, this.swapRateTable, this.displacement, this.beta, this.rhoTable, this.baseVolTable, this.volvolTable, this.correlationDecay, this.iborOisDecorrelation);
    }

    public void setInitialParameters(DataTable initialRhos, DataTable initialBaseVols, DataTable initialVolvols) {
        this.initialRhos = initialRhos;
        this.initialBaseVols = initialBaseVols;
        this.initialVolvols = initialVolvols;
    }

    private DataTableLight findInterpolationNodes() {
        ArrayList<Integer> nodeMaturities = new ArrayList<Integer>();
        ArrayList<Integer> nodeTerminations = new ArrayList<Integer>();
        ArrayList<Double> nodeCardinalities = new ArrayList<Double>();
        TreeSet<Integer> payerStrikes = new TreeSet<Integer>(this.cashPayerPremiums.getGridNodesPerMoneyness().keySet());
        payerStrikes.remove(0);
        TreeSet<Integer> receiverStrikes = new TreeSet<Integer>(this.cashReceiverPremiums.getGridNodesPerMoneyness().keySet());
        receiverStrikes.remove(0);
        for (int maturity : this.cashPayerPremiums.getMaturities()) {
            for (int termination : this.cashPayerPremiums.getTenors()) {
                int strike;
                int count = 1;
                Iterator iterator = payerStrikes.iterator();
                while (iterator.hasNext()) {
                    strike = (Integer)iterator.next();
                    if (!this.cashPayerPremiums.containsEntryFor(maturity, termination, strike)) continue;
                    ++count;
                }
                iterator = receiverStrikes.iterator();
                while (iterator.hasNext()) {
                    strike = (Integer)iterator.next();
                    if (!this.cashReceiverPremiums.containsEntryFor(maturity, termination, strike)) continue;
                    ++count;
                }
                if (count <= true) continue;
                nodeMaturities.add(maturity);
                nodeTerminations.add(termination);
                nodeCardinalities.add(Double.valueOf(count));
            }
        }
        DataTableLight interpolationNodes = new DataTableLight("NodesWithCardinality", DataTable.TableConvention.MONTHS, nodeMaturities, nodeTerminations, nodeCardinalities);
        if (interpolationNodes.size() != interpolationNodes.getMaturities().size() * interpolationNodes.getTerminations().size()) {
            for (int maturity : interpolationNodes.getMaturities()) {
                for (int termination : interpolationNodes.getTerminations()) {
                    if (interpolationNodes.containsEntryFor(maturity, termination)) continue;
                    interpolationNodes = interpolationNodes.addPoint(maturity, termination, 1.0);
                }
            }
        }
        return interpolationNodes;
    }

    private void findInitialParameters() throws SolverException {
        if (this.initialRhos == null || this.initialBaseVols == null || this.initialVolvols == null) {
            SABRShiftedSmileCalibration preCalibration = new SABRShiftedSmileCalibration(this.referenceDate, this.cashPayerPremiums, this.cashReceiverPremiums, this.physicalPremiumsATM, this.model, this.displacement, this.beta, this.correlationDecay, this.iborOisDecorrelation);
            preCalibration.setCalibrationParameters(500, this.numberOfThreads);
            preCalibration.setUseLinearInterpolation(this.useLinearInterpolation);
            SABRVolatilityCube quickCube = preCalibration.build("ShiftedSmileCube");
            this.swapRateTable = quickCube.getUnderlyingTable();
            this.initialRhos = quickCube.getRhoTable();
            this.initialBaseVols = quickCube.getBaseVolTable();
            this.initialVolvols = quickCube.getVolvolTable();
        } else {
            this.makeSwapRateTable();
        }
    }

    private void makeSwapRateTable() {
        ArrayList<Double> swapRates = new ArrayList<Double>();
        ArrayList<Integer> matList = new ArrayList<Integer>();
        ArrayList<Integer> termList = new ArrayList<Integer>();
        SchedulePrototype fixMetaSchedule = this.physicalPremiumsATM.getFixMetaSchedule();
        SchedulePrototype floatMetaSchedule = this.physicalPremiumsATM.getFloatMetaSchedule();
        for (int maturity : this.physicalPremiumsATM.getMaturities()) {
            for (int termination : this.terminations) {
                Schedule floatSchedule = floatMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
                Schedule fixSchedule = fixMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
                swapRates.add(Swap.getForwardSwapRate(fixSchedule, floatSchedule, this.model.getForwardCurve(this.forwardCurveName), this.model));
                matList.add(maturity);
                termList.add(termination);
            }
        }
        this.swapRateTable = this.useLinearInterpolation ? new DataTableLinear("parSwapRates", DataTable.TableConvention.MONTHS, this.referenceDate, floatMetaSchedule, matList, termList, swapRates) : new DataTableInterpolated("parSwapRates", DataTable.TableConvention.MONTHS, this.referenceDate, floatMetaSchedule, matList, termList, swapRates);
    }

    protected void initializeParameters(int maturity) {
        int numberOfSmiles = this.terminations.length;
        this.parameters = new double[numberOfSmiles * 3];
        double[] rhos = new double[numberOfSmiles];
        double[] baseVols = new double[numberOfSmiles];
        double[] volvols = new double[numberOfSmiles];
        for (int i = 0; i < numberOfSmiles; ++i) {
            rhos[i] = this.initialRhos.getValue(maturity, this.terminations[i]);
            baseVols[i] = this.initialBaseVols.getValue(maturity, this.terminations[i]);
            volvols[i] = this.initialVolvols.getValue(maturity, this.terminations[i]);
        }
        System.arraycopy(rhos, 0, this.parameters, 0, numberOfSmiles);
        System.arraycopy(baseVols, 0, this.parameters, numberOfSmiles, numberOfSmiles);
        System.arraycopy(volvols, 0, this.parameters, 2 * numberOfSmiles, numberOfSmiles);
    }

    private void generateTargets(int maturity) {
        this.payerSwaptions = new ArrayList();
        this.receiverSwaptions = new ArrayList();
        ArrayList<Double> targetsPayer = new ArrayList<Double>();
        ArrayList<Double> targetsReceiver = new ArrayList<Double>();
        for (int moneyness : this.cashPayerPremiums.getGridNodesPerMoneyness().keySet()) {
            for (int termination : this.cashPayerPremiums.getTenors(moneyness, maturity)) {
                this.payerSwaptions.add(new SwaptionInfo(moneyness, maturity, termination));
                targetsPayer.add(this.cashPayerPremiums.getValue(maturity, termination, moneyness));
            }
        }
        for (int moneyness : this.cashReceiverPremiums.getGridNodesPerMoneyness().keySet()) {
            for (int termination : this.cashReceiverPremiums.getTenors(moneyness, maturity)) {
                this.receiverSwaptions.add(new SwaptionInfo(-moneyness, maturity, termination));
                targetsReceiver.add(this.cashReceiverPremiums.getValue(maturity, termination, moneyness));
            }
        }
        ArrayList<Double> targetsList = targetsPayer;
        targetsList.addAll(targetsReceiver);
        this.marketTargets = ArrayUtils.toPrimitive((Double[])targetsList.toArray(new Double[0]));
    }

    protected double[] applyParameterBounds(double[] parameters) {
        double[] boundedParameters = new double[parameters.length];
        int numberOfSmiles = this.terminations.length;
        for (int index = 0; index < numberOfSmiles; ++index) {
            boundedParameters[index] = Math.min(0.999999, Math.max(-0.999999, parameters[index]));
            boundedParameters[index + numberOfSmiles] = Math.max(0.0, parameters[index + numberOfSmiles]);
            boundedParameters[index + 2 * numberOfSmiles] = Math.max(0.0, parameters[index + 2 * numberOfSmiles]);
        }
        return boundedParameters;
    }

    private VolatilityCube buildSlice(String name, double[] parameters) {
        DataTableBasic volvolTable;
        DataTableBasic baseVolTable;
        DataTableBasic rhoTable;
        int numberOfSmiles = this.terminations.length;
        int[] maturities = new int[numberOfSmiles];
        Arrays.fill(maturities, this.currentMaturity);
        double[] rhos = Arrays.copyOf(parameters, numberOfSmiles);
        double[] baseVols = Arrays.copyOfRange(parameters, numberOfSmiles, numberOfSmiles * 2);
        double[] volvols = Arrays.copyOfRange(parameters, numberOfSmiles * 2, numberOfSmiles * 3);
        if (this.useLinearInterpolation) {
            rhoTable = new DataTableLinear("rho", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, rhos);
            baseVolTable = new DataTableLinear("baseVol", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, baseVols);
            volvolTable = new DataTableLinear("volvol", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, volvols);
        } else {
            rhoTable = new DataTableInterpolated("rho", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, rhos);
            baseVolTable = new DataTableInterpolated("baseVol", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, baseVols);
            volvolTable = new DataTableInterpolated("volvol", DataTable.TableConvention.MONTHS, this.referenceDate, this.tableMetaSchedule, maturities, this.terminations, volvols);
        }
        SABRVolatilityCube slice = new SABRVolatilityCube(name, this.referenceDate, this.swapRateTable, this.displacement, this.beta, rhoTable, baseVolTable, volvolTable, this.correlationDecay, this.iborOisDecorrelation);
        return slice;
    }

    private void gatherParameters() {
        int numberOfSmiles = this.terminations.length;
        int[] maturities = new int[numberOfSmiles];
        Arrays.fill(maturities, this.currentMaturity);
        double[] rhos = Arrays.copyOf(this.parameters, numberOfSmiles);
        double[] baseVols = Arrays.copyOfRange(this.parameters, numberOfSmiles, numberOfSmiles * 2);
        double[] volvols = Arrays.copyOfRange(this.parameters, numberOfSmiles * 2, numberOfSmiles * 3);
        this.rhoTable = this.rhoTable.addPoints(maturities, this.terminations, rhos);
        this.baseVolTable = this.baseVolTable.addPoints(maturities, this.terminations, baseVols);
        this.volvolTable = this.volvolTable.addPoints(maturities, this.terminations, volvols);
    }

    private void runOptimization() throws SolverException {
        LevenbergMarquardt optimizer = new LevenbergMarquardt(this.parameters, this.marketTargets, this.maxIterations, this.numberOfThreads){
            private static final long serialVersionUID = -264612909413575260L;

            @Override
            public void setValues(double[] parameters, double[] values) {
                AbstractSingleSwapRateProduct css;
                AnnuityMappingFactory factory;
                AnnuityMapping mapping;
                String mappingName;
                double replicationUpperBound;
                double replicationLowerBound;
                double strike;
                double forwardSwapRate;
                Schedule floatSchedule;
                Schedule fixSchedule;
                parameters = SABRCubeCalibration.this.applyParameterBounds(parameters);
                String tempCubeName = "tempCubeSlice";
                VolatilityCube cube = SABRCubeCalibration.this.buildSlice("tempCubeSlice", parameters);
                VolatilityCubeModel tempModel = SABRCubeCalibration.this.model.addVolatilityCube(cube);
                HashMap<String, AnnuityMapping> container = new HashMap<String, AnnuityMapping>();
                int index = 0;
                SchedulePrototype fixMetaSchedule = SABRCubeCalibration.this.cashPayerPremiums.getFixMetaSchedule();
                SchedulePrototype floatMetaSchedule = SABRCubeCalibration.this.cashPayerPremiums.getFloatMetaSchedule();
                for (SwaptionInfo swaption : SABRCubeCalibration.this.payerSwaptions) {
                    fixSchedule = fixMetaSchedule.generateSchedule(SABRCubeCalibration.this.referenceDate, swaption.maturity, swaption.termination);
                    floatSchedule = floatMetaSchedule.generateSchedule(SABRCubeCalibration.this.referenceDate, swaption.maturity, swaption.termination);
                    forwardSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, tempModel.getForwardCurve(SABRCubeCalibration.this.forwardCurveName), tempModel);
                    strike = forwardSwapRate + swaption.moneyness;
                    replicationLowerBound = SABRCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + SABRCubeCalibration.this.replicationLowerBound : SABRCubeCalibration.this.replicationLowerBound;
                    replicationUpperBound = SABRCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + SABRCubeCalibration.this.replicationUpperBound : SABRCubeCalibration.this.replicationUpperBound;
                    mappingName = swaption.toString();
                    if (container.containsKey(mappingName)) {
                        mapping = (AnnuityMapping)container.get(mappingName);
                    } else {
                        factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, SABRCubeCalibration.this.discountCurveName, SABRCubeCalibration.this.forwardCurveName, "tempCubeSlice", strike, replicationLowerBound, replicationUpperBound, SABRCubeCalibration.this.replicationNumberOfEvaluationPoints);
                        mapping = factory.build(SABRCubeCalibration.this.annuityMappingType, tempModel);
                        container.put(mappingName, mapping);
                    }
                    css = new CashSettledPayerSwaption(fixSchedule, floatSchedule, strike, SABRCubeCalibration.this.discountCurveName, SABRCubeCalibration.this.forwardCurveName, "tempCubeSlice", SABRCubeCalibration.this.annuityMappingType, replicationLowerBound, replicationUpperBound, SABRCubeCalibration.this.replicationNumberOfEvaluationPoints);
                    values[index++] = css.getValue(floatSchedule.getFixing(0), mapping, tempModel);
                }
                fixMetaSchedule = SABRCubeCalibration.this.cashReceiverPremiums.getFixMetaSchedule();
                floatMetaSchedule = SABRCubeCalibration.this.cashReceiverPremiums.getFloatMetaSchedule();
                for (SwaptionInfo swaption : SABRCubeCalibration.this.receiverSwaptions) {
                    fixSchedule = fixMetaSchedule.generateSchedule(SABRCubeCalibration.this.referenceDate, swaption.maturity, swaption.termination);
                    floatSchedule = floatMetaSchedule.generateSchedule(SABRCubeCalibration.this.referenceDate, swaption.maturity, swaption.termination);
                    forwardSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, tempModel.getForwardCurve(SABRCubeCalibration.this.forwardCurveName), tempModel);
                    strike = forwardSwapRate + swaption.moneyness;
                    replicationLowerBound = SABRCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + SABRCubeCalibration.this.replicationLowerBound : SABRCubeCalibration.this.replicationLowerBound;
                    replicationUpperBound = SABRCubeCalibration.this.replicationUseAsOffset ? forwardSwapRate + SABRCubeCalibration.this.replicationUpperBound : SABRCubeCalibration.this.replicationUpperBound;
                    mappingName = swaption.toString();
                    if (container.containsKey(mappingName)) {
                        mapping = (AnnuityMapping)container.get(mappingName);
                    } else {
                        factory = new AnnuityMappingFactory(fixSchedule, floatSchedule, SABRCubeCalibration.this.discountCurveName, SABRCubeCalibration.this.forwardCurveName, "tempCubeSlice", strike, replicationLowerBound, replicationUpperBound, SABRCubeCalibration.this.replicationNumberOfEvaluationPoints);
                        mapping = factory.build(SABRCubeCalibration.this.annuityMappingType, tempModel);
                        container.put(mappingName, mapping);
                    }
                    css = new CashSettledReceiverSwaption(fixSchedule, floatSchedule, strike, SABRCubeCalibration.this.discountCurveName, SABRCubeCalibration.this.forwardCurveName, "tempCubeSlice", SABRCubeCalibration.this.annuityMappingType, replicationLowerBound, replicationUpperBound, SABRCubeCalibration.this.replicationNumberOfEvaluationPoints);
                    values[index++] = css.getValue(floatSchedule.getFixing(0), mapping, tempModel);
                }
            }
        };
        optimizer.run();
        System.out.println("Optimizer for maturity " + this.currentMaturity + " finished after " + optimizer.getIterations() + " iterations with mean error " + optimizer.getRootMeanSquaredError());
        this.parameters = this.applyParameterBounds(optimizer.getBestFitParameters());
    }

    public void setCalibrationParameters(int maxIterations, int numberOfThreads) {
        this.maxIterations = maxIterations;
        this.numberOfThreads = numberOfThreads;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setReplicationParameters(boolean useAsOffset, double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.replicationUseAsOffset = useAsOffset;
        this.replicationLowerBound = lowerBound;
        this.replicationUpperBound = upperBound;
        this.replicationNumberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public boolean isReplicationUseAsOffset() {
        return this.replicationUseAsOffset;
    }

    public double getReplicationLowerBound() {
        return this.replicationLowerBound;
    }

    public double getReplicationUpperBound() {
        return this.replicationUpperBound;
    }

    public int getReplicationNumberOfEvaluationPoints() {
        return this.replicationNumberOfEvaluationPoints;
    }

    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    public void setCorrelationDecay(double correlationDecay) {
        this.correlationDecay = correlationDecay;
    }

    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }

    public void setIborOisDecorrelation(double iborOisDecorrelation) {
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public double getBeta() {
        return this.beta;
    }

    public boolean isUseLinearInterpolation() {
        return this.useLinearInterpolation;
    }

    public void setUseLinearInterpolation(boolean useLinearInterpolation) {
        this.useLinearInterpolation = useLinearInterpolation;
    }

    protected class SwaptionInfo {
        private final double moneyness;
        private final LocalDate maturity;
        private final LocalDate termination;

        SwaptionInfo(int moneyness, int maturity, int termination) {
            this.moneyness = (double)moneyness / 10000.0;
            this.maturity = SABRCubeCalibration.this.referenceDate.plusMonths(maturity);
            this.termination = this.maturity.plusMonths(termination);
        }

        SwaptionInfo(int moneyness, int maturity, int termination, DataTable.TableConvention tableConvention) throws IOException {
            this.moneyness = (double)moneyness / 10000.0;
            switch (tableConvention) {
                case MONTHS: {
                    this.maturity = SABRCubeCalibration.this.referenceDate.plusMonths(maturity);
                    this.termination = this.maturity.plusMonths(termination);
                    break;
                }
                case YEARS: {
                    this.maturity = SABRCubeCalibration.this.referenceDate.plusYears(maturity);
                    this.termination = this.maturity.plusYears(termination);
                    break;
                }
                case DAYS: {
                    this.maturity = SABRCubeCalibration.this.referenceDate.plusDays(maturity);
                    this.termination = this.maturity.plusDays(termination);
                    break;
                }
                case WEEKS: {
                    this.maturity = SABRCubeCalibration.this.referenceDate.plusDays(maturity * 7);
                    this.termination = this.maturity.plusDays(termination * 7);
                    break;
                }
                default: {
                    throw new IOException("TableConvention " + (Object)((Object)tableConvention) + " not recognized.");
                }
            }
        }

        public String toString() {
            return this.moneyness + "/" + this.maturity + "/" + this.termination;
        }
    }
}

