/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.calibration;

import java.time.LocalDate;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.calibration.AbstractCubeCalibration;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCubeParallelFactory;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class SABRCubeParallelCalibration
extends AbstractCubeCalibration {
    private double initialCorrelationDecay = 0.0;
    private double initialIborOisDecorrelation = 1.0;
    private double initialDisplacement = 0.25;
    private double initialBeta = 0.5;
    private double initialRho = 0.1;
    private double initialVolvol = 1.0E-4;
    private final SwaptionDataLattice physicalATMSwaptions;

    public SABRCubeParallelCalibration(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, SwaptionDataLattice physicalATMSwaptions, VolatilityCubeModel model, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        super(referenceDate, cashPayerPremiums, cashReceiverPremiums, model, annuityMappingType);
        this.physicalATMSwaptions = physicalATMSwaptions;
    }

    @Override
    protected VolatilityCube buildCube(String name, double[] parameters) {
        return SABRVolatilityCubeParallelFactory.createSABRVolatilityCubeParallel(name, this.getReferenceDate(), this.physicalATMSwaptions.getFixMetaSchedule(), this.physicalATMSwaptions.getFloatMetaSchedule(), this.initialDisplacement, this.initialBeta, parameters[0], parameters[1], this.initialCorrelationDecay, this.initialIborOisDecorrelation, this.physicalATMSwaptions, this.getModel(), this.getForwardCurveName());
    }

    @Override
    protected void initializeParameters() {
        this.setInitialParameters(new double[]{this.initialRho, this.initialVolvol});
    }

    @Override
    protected double[] applyParameterBounds(double[] parameters) {
        double[] boundedParameters = new double[parameters.length];
        boundedParameters[0] = Math.max(-0.999999, Math.min(0.999999, parameters[0]));
        boundedParameters[1] = Math.max(parameters[1], 0.0);
        return boundedParameters;
    }

    public double getInitialCorrelationDecay() {
        return this.initialCorrelationDecay;
    }

    public void setInitialCorrelationDecay(double initialCorrelationDecay) {
        this.initialCorrelationDecay = initialCorrelationDecay;
    }

    public double getInitialIborOisDecorrelation() {
        return this.initialIborOisDecorrelation;
    }

    public void setInitialIborOisDecorrelation(double initialIborOisDecorrelation) {
        this.initialIborOisDecorrelation = initialIborOisDecorrelation;
    }

    public double getInitialDisplacement() {
        return this.initialDisplacement;
    }

    public void setInitialDisplacement(double initialDisplacement) {
        this.initialDisplacement = initialDisplacement;
    }

    public double getInitialBeta() {
        return this.initialBeta;
    }

    public void setInitialBeta(double initialBeta) {
        this.initialBeta = initialBeta;
    }

    public double getInitialRho() {
        return this.initialRho;
    }

    public void setInitialRho(double initialRho) {
        this.initialRho = initialRho;
    }

    public double getInitialVolvol() {
        return this.initialVolvol;
    }

    public void setInitialVolvol(double initialVolvol) {
        this.initialVolvol = initialVolvol;
    }
}

