/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableLight;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public class DataTableBasic
implements DataTable,
Cloneable {
    private static final long serialVersionUID = -529758680500367511L;
    private final String name;
    private final DataTable.TableConvention convention;
    private final LocalDate referenceDate;
    private final SchedulePrototype metaSchedule;
    private final TreeSet<Integer> maturitySet = new TreeSet();
    private final TreeSet<Integer> terminationSet = new TreeSet();
    private final HashMap<DoubleKey, Double> entries = new HashMap();

    public static DataTableBasic upgradeDataTableLight(DataTableLight baseTable, LocalDate referenceDate, SchedulePrototype scheduleMetaData) {
        int[] maturities = new int[baseTable.size()];
        int[] terminations = new int[baseTable.size()];
        double[] values = new double[baseTable.size()];
        int i = 0;
        for (int maturity : baseTable.getMaturities()) {
            for (int termination : baseTable.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = baseTable.getValue(maturity, termination);
            }
        }
        return new DataTableBasic(baseTable.getName(), baseTable.getConvention(), referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    public DataTableBasic(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData) {
        this.name = name;
        this.convention = convention;
        this.referenceDate = referenceDate;
        this.metaSchedule = scheduleMetaData;
    }

    public DataTableBasic(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, int[] maturities, int[] terminations, double[] values) {
        this(name, convention, referenceDate, scheduleMetaData);
        for (int index = 0; index < maturities.length; ++index) {
            this.entries.put(new DoubleKey(maturities[index], terminations[index]), values[index]);
            this.maturitySet.add(maturities[index]);
            this.terminationSet.add(terminations[index]);
        }
    }

    public DataTableBasic(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, List<Integer> maturities, List<Integer> terminations, List<Double> values) {
        this(name, convention, referenceDate, scheduleMetaData);
        for (int index = 0; index < maturities.size(); ++index) {
            int mat = maturities.get(index);
            int term = terminations.get(index);
            double val = values.get(index);
            this.entries.put(new DoubleKey(mat, term), val);
            this.maturitySet.add(mat);
            this.terminationSet.add(term);
        }
    }

    @Override
    public DataTable addPoint(int maturity, int termination, double value) {
        DataTableBasic newTable = this.clone();
        newTable.entries.put(new DoubleKey(maturity, termination), value);
        newTable.maturitySet.add(maturity);
        newTable.terminationSet.add(termination);
        return newTable;
    }

    @Override
    public DataTable addPoints(int[] maturities, int[] terminations, double[] values) {
        DataTableBasic newTable = this.clone();
        for (int index = 0; index < maturities.length; ++index) {
            newTable.entries.put(new DoubleKey(maturities[index], terminations[index]), values[index]);
            newTable.maturitySet.add(maturities[index]);
            newTable.terminationSet.add(terminations[index]);
        }
        return newTable;
    }

    @Override
    public double getValue(int maturity, int termination) {
        DoubleKey key = new DoubleKey(maturity, termination);
        if (this.entries.containsKey(key)) {
            return this.entries.get(new DoubleKey(maturity, termination));
        }
        throw new NullPointerException("Key not found.");
    }

    @Override
    public double getValue(double maturity, double termination) {
        DoubleKey key = new DoubleKey(maturity, termination);
        if (this.entries.containsKey(key)) {
            return this.entries.get(new DoubleKey(maturity, termination));
        }
        throw new NullPointerException("Key not found.");
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean containsEntryFor(int maturity, int termination) {
        return this.entries.containsKey(new DoubleKey(maturity, termination));
    }

    @Override
    public boolean containsEntryFor(double maturity, double termination) {
        return this.entries.containsKey(new DoubleKey(maturity, termination));
    }

    @Override
    public TreeSet<Integer> getMaturities() {
        return new TreeSet<Integer>((SortedSet<Integer>)this.maturitySet);
    }

    @Override
    public TreeSet<Integer> getTerminations() {
        return new TreeSet<Integer>((SortedSet<Integer>)this.terminationSet);
    }

    @Override
    public TreeSet<Integer> getTerminationsForMaturity(int maturity) {
        if (this.maturitySet.contains(maturity)) {
            TreeSet<Integer> returnSet = new TreeSet<Integer>();
            for (int termination : this.terminationSet) {
                if (!this.entries.containsKey(new DoubleKey(maturity, termination))) continue;
                returnSet.add(termination);
            }
            return returnSet;
        }
        throw new NullPointerException("This data table does not contain entries for maturity " + maturity);
    }

    @Override
    public TreeSet<Integer> getMaturitiesForTermination(int termination) {
        if (this.terminationSet.contains(termination)) {
            TreeSet<Integer> returnSet = new TreeSet<Integer>();
            for (int maturity : this.maturitySet) {
                if (!this.entries.containsKey(new DoubleKey(maturity, termination))) continue;
                returnSet.add(maturity);
            }
            return returnSet;
        }
        throw new NullPointerException("This data table does not contain entries for termination " + termination);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public DataTable.TableConvention getConvention() {
        return this.convention;
    }

    @Override
    public SchedulePrototype getScheduleMetaData() {
        return this.metaSchedule;
    }

    @Override
    public DataTableBasic clone() {
        DataTableBasic newTable = new DataTableBasic(this.name, this.convention, this.referenceDate, this.metaSchedule);
        newTable.entries.putAll(this.entries);
        newTable.maturitySet.addAll(this.maturitySet);
        newTable.terminationSet.addAll(this.terminationSet);
        return newTable;
    }

    public String toString() {
        return this.toString(1.0);
    }

    public String toString(double unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("DataTableBasic [name=" + this.name + ", referenceDate=" + this.referenceDate + ", tableConvention=" + (Object)((Object)this.convention) + ", scheduleMetaData=" + this.metaSchedule + "values:\n");
        for (int termination : this.terminationSet) {
            builder.append("\t" + termination);
        }
        for (int maturity : this.maturitySet) {
            builder.append("\n" + maturity);
            for (int termination : this.terminationSet) {
                DoubleKey key = new DoubleKey(maturity, termination);
                builder.append('\t');
                if (!this.entries.containsKey(key)) continue;
                builder.append(this.entries.get(key) * unit);
            }
        }
        return builder.toString();
    }

    protected double getValue(DoubleKey key) {
        return this.entries.get(key);
    }

    protected class DoubleKey
    implements Serializable {
        private static final long serialVersionUID = -2372959679853584772L;
        private final double maturity;
        private final double termination;

        protected DoubleKey(int maturity, int termination) {
            LocalDate startDate = this.dateFromOffset(DataTableBasic.this.referenceDate, maturity);
            LocalDate endDate = this.dateFromOffset(startDate, termination);
            Schedule schedule = DataTableBasic.this.metaSchedule.generateSchedule(DataTableBasic.this.referenceDate, startDate, endDate);
            this.maturity = schedule.getFixing(0);
            this.termination = schedule.getPayment(schedule.getNumberOfPeriods() - 1);
        }

        protected DoubleKey(double maturity, double termination) {
            this.maturity = maturity;
            this.termination = termination;
        }

        private LocalDate dateFromOffset(LocalDate startDate, int offset) {
            LocalDate date = null;
            switch (DataTableBasic.this.convention) {
                case YEARS: {
                    date = startDate.plusYears(offset);
                    break;
                }
                case MONTHS: {
                    date = startDate.plusMonths(offset);
                    break;
                }
                case DAYS: {
                    date = startDate.plusDays(offset);
                    break;
                }
                case WEEKS: {
                    date = startDate.plusWeeks(offset);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown convention " + (Object)((Object)DataTableBasic.this.convention) + ".");
                }
            }
            return date;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            if (this.maturity != ((DoubleKey)other).maturity) {
                return false;
            }
            return this.termination == ((DoubleKey)other).termination;
        }

        public int hashCode() {
            return (int)(this.maturity * this.termination);
        }

        public String toString() {
            return "DoubleKey [maturity=" + this.maturity + ", termination=" + this.termination + "]";
        }
    }
}

